/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.aas.HasSemantics;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.KeyElements;
import org.eclipse.papyrus.aas.KeyType;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public final class KeyUtils {
    public static boolean isKey(EObject eObject) {
        if (eObject instanceof Element) {
            Element element = (Element)eObject;
            return KeyUtils.getStereotypeApplication(element) != null;
        }
        return false;
    }

    public static Key getStereotypeApplication(Element element) {
        Key key = null;
        if (element != null) {
            key = (Key)UMLUtil.getStereotypeApplication((Element)element, Key.class);
        }
        return key;
    }

    public static HasSemantics getHasSemanticsApplication(Element element) {
        HasSemantics hassemantics = null;
        if (element != null) {
            hassemantics = (HasSemantics)UMLUtil.getStereotypeApplication((Element)element, HasSemantics.class);
        }
        return hassemantics;
    }

    public static KeyElements getType(Key property) {
        return property.getType();
    }

    public static KeyType getidType(Element element) {
        return KeyUtils.getStereotypeApplication(element) == null ? null : KeyUtils.getStereotypeApplication(element).getIdType();
    }

    public static String getRegistration(Element element) {
        return KeyUtils.getStereotypeApplication(element) == null ? null : KeyUtils.getStereotypeApplication(element).getValue();
    }

    private static Key getKeyFromUMLElement(Element umlElement) {
        Stereotype sterotype;
        Reference semanticid;
        if (umlElement != null && (semanticid = (Reference)umlElement.getValue(sterotype = org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedStereotype((Element)umlElement, (String)"AAS::HasSemantics", (boolean)false), "semanticId")) != null && semanticid.getKey() != null) {
            Key key = (Key)semanticid.getKey().get(0);
            return key;
        }
        return null;
    }
}

