/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator.Template2StructureGeneratorDescription;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;

public final class Template2StructureGeneratorExtensionReader {
    private final String EXTENSION_ID = "org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator";
    private static final String MAPPER = "mapper";
    private static final String GENERATOR = "generator";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String GENERATOR_ID_ATTRIBUTE = "generatorId";
    private static final String INHERITS_MAPPER_FROM_GENERATOR_ATTRIBUTE = "inheritsMapperFromGenerator";

    public Map<String, Template2StructureGeneratorDescription> readContributions() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator");
        ArrayList<IConfigurationElement> generatorContributions = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> mapperContributions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (GENERATOR.equals(iConfigurationElement.getName())) {
                generatorContributions.add(iConfigurationElement);
            } else if (MAPPER.equals(iConfigurationElement.getName())) {
                mapperContributions.add(iConfigurationElement);
            }
            ++n2;
        }
        Map<String, Template2StructureGeneratorDescription> generatorDescriptions = this.readGeneratorConfigurations(generatorContributions);
        this.associateMappersToGenerators(generatorDescriptions, mapperContributions);
        this.associateInheritedGenerator(generatorDescriptions);
        this.checkInheritance(generatorDescriptions);
        return generatorDescriptions;
    }

    private Map<String, Template2StructureGeneratorDescription> readGeneratorConfigurations(Collection<IConfigurationElement> generatorContributions) {
        HashMap<String, Template2StructureGeneratorDescription> generatorDescriptions = new HashMap<String, Template2StructureGeneratorDescription>();
        for (IConfigurationElement iConfigurationElement : generatorContributions) {
            ArrayList<String> messageParameters;
            String expectedId;
            String registeredId = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
            String inheritedGeneratorId = iConfigurationElement.getAttribute(INHERITS_MAPPER_FROM_GENERATOR_ATTRIBUTE);
            ITemplate2StructureGenerator generator = null;
            try {
                generator = (ITemplate2StructureGenerator)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                Activator.log.error(NLS.bind((String)"The generator {0} can't be loaded.", (Object)iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
            }
            if (generator == null) continue;
            if (registeredId == null || registeredId.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"The contributed generator {0} is ignored because you don't define id for it in your extension point contribution {1}", (Object)generator.toString(), (Object)"org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator/generator"));
            }
            if (!registeredId.equals(expectedId = generator.getGeneratorId())) {
                messageParameters = new ArrayList<String>();
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                messageParameters.add(expectedId);
                Activator.log.warn(NLS.bind((String)"The generator {0} is declared with the id {1} is the extension point contribution, but it should be {2} as declared inside it. We ignore it.", (Object[])messageParameters.toArray()));
                continue;
            }
            if (generatorDescriptions.containsKey(registeredId)) {
                messageParameters = new ArrayList();
                messageParameters.add(((Template2StructureGeneratorDescription)generatorDescriptions.get(registeredId)).getGenerator().toString());
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                Activator.log.warn(NLS.bind((String)"The generators {0} and {1} are regitered with the same id {3}. We ignore the second one", (Object[])messageParameters.toArray()));
                continue;
            }
            Template2StructureGeneratorDescription description = new Template2StructureGeneratorDescription(generator, inheritedGeneratorId);
            generatorDescriptions.put(generator.getGeneratorId(), description);
        }
        return generatorDescriptions;
    }

    private void associateMappersToGenerators(Map<String, Template2StructureGeneratorDescription> generatorDescriptions, Collection<IConfigurationElement> mapperContributions) {
        for (IConfigurationElement iConfigurationElement : mapperContributions) {
            String contributedGenerator = iConfigurationElement.getAttribute(GENERATOR_ID_ATTRIBUTE);
            AbstractTemplateToStructureMapper mapper = null;
            try {
                mapper = (AbstractTemplateToStructureMapper)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                Activator.log.error(NLS.bind((String)"The mapper {0} can't be loaded.", (Object)iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
            }
            if (mapper == null) continue;
            if (contributedGenerator == null || contributedGenerator.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"The contributed mapper {0} is ignored because you don't define id for it in your extension point contribution {1}", (Object)mapper.toString(), (Object)"org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator/mapper"));
                continue;
            }
            Template2StructureGeneratorDescription generatorDescription = generatorDescriptions.get(contributedGenerator);
            if (generatorDescription == null) {
                Activator.log.warn(NLS.bind((String)"The contributed mapper {0} is ignored because we can't find generator with id {1}", (Object)mapper.toString(), (Object)contributedGenerator));
                continue;
            }
            generatorDescription.registerMapper(mapper);
        }
    }

    private void associateInheritedGenerator(Map<String, Template2StructureGeneratorDescription> generatorDescriptions) {
        for (Template2StructureGeneratorDescription current : generatorDescriptions.values()) {
            String inheritedGeneratorId = current.getInheritsFromGeneratorId();
            if (inheritedGeneratorId == null || inheritedGeneratorId.isEmpty()) continue;
            Template2StructureGeneratorDescription parent = generatorDescriptions.get(inheritedGeneratorId);
            if (parent == null) {
                Activator.log.warn(NLS.bind((String)"The generator {0} is not found. It is defines as parent for {1}", (Object)inheritedGeneratorId, (Object)current.getGeneratorId()));
                continue;
            }
            current.setInheritedGenerator(parent);
        }
    }

    private void checkInheritance(Map<String, Template2StructureGeneratorDescription> generatorDescriptions) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Template2StructureGeneratorDescription template2StructureGeneratorDescription : generatorDescriptions.values()) {
            IStatus status = this.validateInheritance(template2StructureGeneratorDescription);
            if (status.isOK()) continue;
            Activator.log.warn(NLS.bind((String)"The generator {0} is ignored. {1}", (Object)template2StructureGeneratorDescription.getGeneratorId(), (Object)status.getMessage()));
            toRemove.add(template2StructureGeneratorDescription.getGeneratorId());
        }
        for (String string : toRemove) {
            generatorDescriptions.remove(string);
        }
    }

    private IStatus validateInheritance(Template2StructureGeneratorDescription generatorDescription) {
        ArrayList<Template2StructureGeneratorDescription> crossedParent = new ArrayList<Template2StructureGeneratorDescription>();
        Template2StructureGeneratorDescription parent = generatorDescription;
        while (parent != null && !crossedParent.contains(parent)) {
            crossedParent.add(parent);
            parent = parent.getInheritedGenerator();
        }
        if (parent == null) {
            return Status.OK_STATUS;
        }
        StringBuilder builder = new StringBuilder();
        Iterator iter = crossedParent.iterator();
        while (iter.hasNext()) {
            builder.append(((Template2StructureGeneratorDescription)iter.next()).getGeneratorId());
            builder.append(" -> ");
        }
        builder.append(parent.getGeneratorId());
        String message = NLS.bind((String)"There is an infinite inheritance loop for {0} : {1}", (Object)generatorDescription.getGeneratorId(), (Object)builder.toString());
        return new Status(4, "org.eclipse.papyrus.model2doc.emf.template2structure", message);
    }
}

