/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.table.TableBorder2;
import com.sun.star.table.TableBorderDistances;
import com.sun.star.table.XCell;
import com.sun.star.text.TableColumnSeparator;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.XCellUtils;

public class XTextTableUtils {
    private XTextTableUtils() {
    }

    public static final void setColumnsWidthInUnit(XTextTable textTable, List<Double> columnsWitdhInUnit) {
        double fullUnit = 0.0;
        for (Double current : columnsWitdhInUnit) {
            fullUnit += current.doubleValue();
        }
        if (fullUnit != 0.0) {
            ArrayList<Double> percentage = new ArrayList<Double>(columnsWitdhInUnit.size());
            int i = 0;
            while (i < columnsWitdhInUnit.size()) {
                percentage.add(columnsWitdhInUnit.get(i) / fullUnit);
                ++i;
            }
            XTextTableUtils.setColumnsWidth(textTable, percentage);
        } else {
            Activator.log.warn("The columns width has not been set, because you don't give us values > 0");
        }
    }

    public static final void setColumnsWidth(XTextTable textTable, List<Double> columnsInPercentage) {
        try {
            XPropertySet xPS = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textTable);
            Object xObj = xPS.getPropertyValue("TableColumnSeparators");
            short tableWidthRelative = (Short)PropertySetUtil.getPropertyValue(textTable, "TableColumnRelativeSum");
            TableColumnSeparator[] colSep1 = (TableColumnSeparator[])UnoRuntime.queryInterface(TableColumnSeparator[].class, (Object)xObj);
            Assert.isTrue((columnsInPercentage.size() == colSep1.length + 1 ? 1 : 0) != 0, (String)NLS.bind((String)"There are {0} column's separators for {1} width to set.", (Object)colSep1.length, (Object)columnsInPercentage.size()));
            double consumedWidth = 0.0;
            int j = 0;
            while (j < colSep1.length) {
                double result = columnsInPercentage.get(j) * (double)tableWidthRelative;
                colSep1[j].Position = (short)Math.ceil(consumedWidth += result);
                ++j;
            }
            xPS.setPropertyValue("TableColumnSeparators", (Object)colSep1);
        }
        catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException e) {
            Activator.log.error(e);
        }
    }

    public static final void setTableBorderWidth(XTextTable xTextTable, int borderWidth) {
        TableBorder2 tb2 = (TableBorder2)PropertySetUtil.getPropertyValue(xTextTable, "TableBorder2");
        tb2.LeftLine.LineWidth = borderWidth;
        tb2.RightLine.LineWidth = borderWidth;
        tb2.TopLine.LineWidth = borderWidth;
        tb2.BottomLine.LineWidth = borderWidth;
        PropertySetUtil.setProperty(xTextTable, "TableBorder2", tb2);
    }

    public static final void setTableMarginDistance(XTextTable xTextTable, short distance) {
        TableBorder2 tb2 = (TableBorder2)PropertySetUtil.getPropertyValue(xTextTable, "TableBorder2");
        tb2.LeftLine.LineDistance = distance;
        tb2.RightLine.LineDistance = distance;
        tb2.TopLine.LineDistance = distance;
        tb2.BottomLine.LineDistance = distance;
        PropertySetUtil.setProperty(xTextTable, "TableBorder2", tb2);
    }

    public static final void removeTableMargin(XTextTable xTextTable) {
        XTextTableUtils.setTableMarginDistance(xTextTable, (short)0);
    }

    public static final void hideTableBorder(XTextTable xTextTable, String border) {
        List<String> cellNames = Arrays.asList(xTextTable.getCellNames());
        Iterator<String> libreOfficeCellNamesIter = cellNames.iterator();
        while (libreOfficeCellNamesIter.hasNext()) {
            XCell cell = xTextTable.getCellByName(libreOfficeCellNamesIter.next());
            XCellUtils.hideCellBorder(cell, border);
        }
    }

    public static final void hideTableTopBorder(XTextTable xTextTable) {
        XTextTableUtils.hideTableBorder(xTextTable, "TopBorder");
    }

    public static final void hideTableBottomBorder(XTextTable xTextTable) {
        XTextTableUtils.hideTableBorder(xTextTable, "BottomBorder");
    }

    public static final void hideTableLeftBorder(XTextTable xTextTable) {
        XTextTableUtils.hideTableBorder(xTextTable, "LeftBorder");
    }

    public static final void hideTableRightBorder(XTextTable xTextTable) {
        XTextTableUtils.hideTableBorder(xTextTable, "RightBorder");
    }

    public static final void removeTableBorderDistance(XTextTable xTextTable) {
        TableBorderDistances d = (TableBorderDistances)PropertySetUtil.getPropertyValue(xTextTable, "TableBorderDistances");
        d.BottomDistance = 0;
        d.LeftDistance = 0;
        d.RightDistance = 0;
        d.TopDistance = 0;
        PropertySetUtil.setProperty(xTextTable, "TableBorderDistances", d);
    }
}

