/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.TypeQualifiedNameContentProposal;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.TypeShortNameContentProposal;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ITypeCatalog;
import org.eclipse.uml2.uml.Type;

public class TypeContentProposalProvider
implements IContentProposalProvider {
    private ITypeCatalog typeCatalog;

    public TypeContentProposalProvider(ITypeCatalog typeCatalog) {
        this.typeCatalog = typeCatalog;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<TypeShortNameContentProposal> shortProposals = new ArrayList<TypeShortNameContentProposal>();
        ArrayList<TypeQualifiedNameContentProposal> longProposals = new ArrayList<TypeQualifiedNameContentProposal>();
        List<Type> types = this.typeCatalog.getTypes();
        for (Type type : types) {
            String simpleName = type.getName();
            String qualifiedName = type.getQualifiedName();
            if (this.match(simpleName, contents, position)) {
                shortProposals.add(new TypeShortNameContentProposal(type));
            }
            if (!this.match(qualifiedName, contents, position)) continue;
            longProposals.add(new TypeQualifiedNameContentProposal(type));
        }
        Collections.sort(shortProposals);
        Collections.sort(longProposals);
        shortProposals.addAll(longProposals);
        return shortProposals.toArray(new IContentProposal[shortProposals.size()]);
    }

    private boolean match(String name, String proposal, int position) {
        return position < name.length() && proposal.substring(0, position).equalsIgnoreCase(name.substring(0, position));
    }
}

