/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.Editor;
import xpt.editor.VisualIDRegistry;
import xpt.navigator.getEditorInput;

@Singleton
public class OpenDiagram {
    @Inject
    @Extension
    private Common _common;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private getEditorInput xptGetEditorInput;
    @Inject
    private Activator xptActivator;
    @Inject
    private Editor xptEditor;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;

    public CharSequence className(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPolicyClassName = it.getEditPolicyClassName();
        _builder.append(_editPolicyClassName);
        return _builder;
    }

    public CharSequence packageName(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPoliciesPackageName = it.getSubject().getDiagram().getEditPoliciesPackageName();
        _builder.append(_editPoliciesPackageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence OpenDiagram(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getSubject().getDiagram().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" ");
        CharSequence _implementsList = this.implementsList(it);
        _builder.append((Object)_implementsList);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _openCommand = this.getOpenCommand(it);
        _builder.append((Object)_openCommand, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _openCommandClass = this.openCommandClass(it);
        _builder.append((Object)_openCommandClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence extendsList(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy");
        return _builder;
    }

    public CharSequence implementsList(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence getOpenCommand(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gef.commands.Command getOpenCommand(org.eclipse.gef.Request request) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gef.EditPart targetEditPart = getTargetEditPart(request);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (false == targetEditPart.getModel() instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) targetEditPart.getModel();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Style link = view.getStyle(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getHintedDiagramLinkStyle());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (false == link instanceof org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy(new OpenDiagramCommand((org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle) link));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence additions(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence openCommandClass(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private static class OpenDiagramCommand ");
        CharSequence _openCommandClass_extendsList = this.openCommandClass_extendsList(it);
        _builder.append((Object)_openCommandClass_extendsList, "\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _openCommandClass_fields = this.openCommandClass_fields(it);
        _builder.append((Object)_openCommandClass_fields, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _openCommandClass_constructor = this.openCommandClass_constructor(it);
        _builder.append((Object)_openCommandClass_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// FIXME canExecute if  !(readOnly && getDiagramToOpen == null), i.e. open works on ro diagrams only when there's associated diagram already");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_doExecuteWithResult = this.openCommandClass_doExecuteWithResult(it);
        _builder.append((Object)_openCommandClass_doExecuteWithResult, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_getDiagramToOpen = this.openCommandClass_getDiagramToOpen(it);
        _builder.append((Object)_openCommandClass_getDiagramToOpen, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_intializeNewDiagram = this.openCommandClass_intializeNewDiagram(it);
        _builder.append((Object)_openCommandClass_intializeNewDiagram, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_getDiagramDomainElement = this.openCommandClass_getDiagramDomainElement(it);
        _builder.append((Object)_openCommandClass_getDiagramDomainElement, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_getPreferencesHint = this.openCommandClass_getPreferencesHint(it);
        _builder.append((Object)_openCommandClass_getPreferencesHint, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_getDiagramKind = this.openCommandClass_getDiagramKind(it);
        _builder.append((Object)_openCommandClass_getDiagramKind, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_getEditorID = this.openCommandClass_getEditorID(it);
        _builder.append((Object)_openCommandClass_getEditorID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _openCommandClass_additions = this.openCommandClass_additions(it);
        _builder.append((Object)_openCommandClass_additions, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_extendsList(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand");
        return _builder;
    }

    public CharSequence openCommandClass_fields(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private final org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle diagramFacet;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_constructor(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("OpenDiagramCommand(org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle linkStyle) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// editing domain is taken for original diagram, ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// if we open diagram from another file, we should use another editing domain");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super(org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(linkStyle), ");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getSubject().getDiagram().getEditorGen(), this.i18nKeyForOpenCommandName());
        _builder.append((Object)_accessorCall, "\t");
        _builder.append(", null);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("diagramFacet = linkStyle;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_doExecuteWithResult(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = getDiagramToOpen();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (diagram == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("diagram = intializeNewDiagram();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _defineURIEditorInput = this.xptGetEditorInput.defineURIEditorInput(it.getSubject().getDiagram(), "diagram", "editorInput");
        _builder.append((Object)_defineURIEditorInput, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.ui.IWorkbenchPage page = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("page.openEditor(editorInput, getEditorID());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (Exception ex) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Can't open diagram\", ex);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_getDiagramToOpen(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.notation.Diagram getDiagramToOpen() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return diagramFacet.getDiagramLink();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_intializeNewDiagram(OpenDiagramBehaviour it) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.notation.Diagram intializeNewDiagram() throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram d = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createDiagram(getDiagramDomainElement(), getDiagramKind(), getPreferencesHint());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (d == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Can't create diagram of '\" + getDiagramKind() + \"' kind\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("diagramFacet.setDiagramLink(d);");
        _builder.newLine();
        _builder.append("\t");
        CharSequence __assert = this._common._assert("diagramFacet.eResource() != null");
        _builder.append((Object)__assert, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("diagramFacet.eResource().getContents().add(d);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject container = diagramFacet.eContainer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while (container instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("((org.eclipse.gmf.runtime.notation.View) container).persist();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("container = container.eContainer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        GenApplication _application = it.getSubject().getDiagram().getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("\t");
            _builder.append("new org.eclipse.ui.actions.WorkspaceModifyOperation() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("protected void execute(org.eclipse.core.runtime.IProgressMonitor monitor) throws org.eclipse.core.runtime.CoreException, java.lang.reflect.InvocationTargetException, InterruptedException {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("try {");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("for (java.util.Iterator<?> it = diagramFacet.eResource().getResourceSet().getResources().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = (org.eclipse.emf.ecore.resource.Resource) it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (nextResource.isLoaded() && !getEditingDomain().isReadOnly(nextResource)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("nextResource.save(");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it.getSubject().getDiagram());
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append(".getSaveOptions());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        GenApplication _application_1 = it.getSubject().getDiagram().getEditorGen().getApplication();
        boolean bl2 = _tripleEquals_1 = _application_1 == null;
        if (_tripleEquals_1) {
            _builder.append("\t");
            _builder.append("} catch (java.io.IOException ex) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("throw new java.lang.reflect.InvocationTargetException(ex, \"Save operation failed\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}.run(null);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} catch (java.lang.reflect.InvocationTargetException e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Can't create diagram of '\" + getDiagramKind() + \"' kind\", e);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} catch (InterruptedException e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Can't create diagram of '\" + getDiagramKind() + \"' kind\", e);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("} catch (java.io.IOException ex) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Can't create diagram of '\" + getDiagramKind() + \"' kind\", ex);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return d;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_getDiagramDomainElement(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.emf.ecore.EObject getDiagramDomainElement() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// use same element as associated with EP");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ((org.eclipse.gmf.runtime.notation.View) diagramFacet.eContainer()).getElement();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_getPreferencesHint(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint getPreferencesHint() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// XXX prefhint from target diagram's editor?");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getSubject().getDiagram().getEditorGen());
        _builder.append((Object)_preferenceHintAccess, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_getDiagramKind(OpenDiagramBehaviour it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected String getDiagramKind() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _diagramKind = it.getDiagramKind();
        boolean bl = _tripleEquals = _diagramKind == null;
        if (_tripleEquals) {
            CharSequence _modelID = VisualIDRegistry.modelID(it.getSubject().getDiagram());
            _builder.append((Object)_modelID, "\t");
        } else {
            _builder.append("\"");
            String _diagramKind_1 = it.getDiagramKind();
            _builder.append(_diagramKind_1, "\t");
            _builder.append("\"");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_getEditorID(OpenDiagramBehaviour it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected String getEditorID() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _editorID = it.getEditorID();
        boolean bl = _tripleEquals = _editorID == null;
        if (_tripleEquals) {
            CharSequence _qualifiedClassName = this.xptEditor.qualifiedClassName(it.getSubject().getDiagram().getEditorGen().getEditor());
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append(".ID");
        } else {
            _builder.append("\"");
            String _editorID_1 = it.getEditorID();
            _builder.append(_editorID_1, "\t");
            _builder.append("\"");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openCommandClass_additions(OpenDiagramBehaviour it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @Localization
    public String i18nKeyForOpenCommandName() {
        return "CommandName.OpenDiagram";
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForOpenCommandName());
        _builder.append((Object)_accessorField);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForOpenCommandName(), "Open Diagram");
        _builder.append((Object)_messageEntry);
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

