/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure;

import java.util.List;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;

public final class CaseProcedure<T>
implements Procedure<T> {
    private static final long serialVersionUID = 1L;
    private final List<Pair<Predicate<? super T>, Procedure<? super T>>> predicateProcedures = Lists.mutable.empty();
    private Procedure<? super T> defaultProcedure;

    public CaseProcedure(Procedure<? super T> defaultProcedure) {
        this.defaultProcedure = defaultProcedure;
    }

    public CaseProcedure() {
    }

    public CaseProcedure<T> addCase(Predicate<? super T> predicate, Procedure<? super T> procedure) {
        this.predicateProcedures.add(Tuples.pair(predicate, procedure));
        return this;
    }

    public CaseProcedure<T> setDefault(Procedure<? super T> procedure) {
        this.defaultProcedure = procedure;
        return this;
    }

    @Override
    public void value(T argument) {
        int localSize = this.predicateProcedures.size();
        for (int i = 0; i < localSize; ++i) {
            Pair<Predicate<T>, Procedure<T>> pair = this.predicateProcedures.get(i);
            if (!pair.getOne().accept(argument)) continue;
            pair.getTwo().value(argument);
            return;
        }
        if (this.defaultProcedure != null) {
            this.defaultProcedure.value(argument);
        }
    }

    public String toString() {
        return "new CaseProcedure(" + this.predicateProcedures + ')';
    }
}

