/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.TupleFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstanceImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.OperationOverrideMap;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstanceImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.types.CollectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInstanceFactory
extends EFactoryImpl {
    private TupleFactory fTupleFactory;
    private List<PostCreateHandler> fPostCreateHandlers = Collections.emptyList();

    public ModuleInstanceFactory() {
        this.fTupleFactory = new TupleFactory();
    }

    public void addPostCreateHandler(PostCreateHandler postCreateHandler) {
        if (postCreateHandler == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPostCreateHandlers.isEmpty()) {
            this.fPostCreateHandlers = new LinkedList<PostCreateHandler>();
        }
        this.fPostCreateHandlers.add(postCreateHandler);
    }

    public EObject create(EClass eClass) {
        if (this.getEPackage() != eClass.getEPackage() || eClass.isAbstract()) {
            if (eClass instanceof TupleType) {
                return this.fTupleFactory.create(eClass);
            }
            if (!(eClass instanceof Module)) {
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
            }
        }
        return this.basicCreate(eClass);
    }

    protected EObject basicCreate(EClass eClass) {
        if (eClass instanceof Module) {
            Module module = (Module)eClass;
            Map<Module, OperationOverrideMap> overrideMap = OperationOverrideMap.create(module);
            HashMap<Module, ModuleInstance> instanceMap = new HashMap<Module, ModuleInstance>(3);
            this.basicCreateModuleInstance(QvtOperationalStdLibrary.INSTANCE.getStdLibModule(), instanceMap, overrideMap);
            ModuleInstance result = this.createModuleInstance(module, instanceMap, overrideMap);
            return result;
        }
        if (eClass instanceof ModelType) {
            return new ModelInstanceImpl((ModelType)eClass, new ModelParameterExtent());
        }
        if (eClass instanceof TupleType) {
            return TupleFactory.createTuple(eClass);
        }
        return super.basicCreate(eClass);
    }

    protected final ModuleInstance createModuleInstance(Module module, Map<Module, ModuleInstance> instanceMap, Map<Module, OperationOverrideMap> overrideMap) {
        ModuleInstance moduleInstance = instanceMap.get(module);
        if (moduleInstance == null) {
            moduleInstance = this.basicCreateModuleInstance(module, instanceMap, overrideMap);
            for (ModuleImport moduleImport : module.getModuleImport()) {
                Module importedModule = moduleImport.getImportedModule();
                if (moduleImport.getKind() != ImportKind.EXTENSION && !(importedModule instanceof Library)) continue;
                this.createModuleInstance(importedModule, instanceMap, overrideMap);
            }
        }
        return moduleInstance;
    }

    protected final ModuleInstanceImpl basicCreateModuleInstance(Module module, Map<Module, ModuleInstance> instanceMap, Map<Module, OperationOverrideMap> overrideMap) {
        ModuleInstanceImpl moduleInstance = module instanceof OperationalTransformation ? new TransformationInstanceImpl((OperationalTransformation)module) : new ModuleInstanceImpl(module);
        moduleInstance.setInstanceMap(instanceMap);
        instanceMap.put(module, moduleInstance);
        if (overrideMap != null) {
            moduleInstance.setOverrideMap(overrideMap);
        }
        ModuleInstanceFactory.initProperties(moduleInstance);
        ModuleInstanceFactory factory = this;
        if (module.getEFactoryInstance() instanceof ModuleInstanceFactory) {
            factory = (ModuleInstanceFactory)module.getEFactoryInstance();
            factory.notifyModuleCreated(moduleInstance);
        }
        if (factory != this) {
            this.notifyModuleCreated(moduleInstance);
        }
        return moduleInstance;
    }

    private void notifyModuleCreated(ModuleInstanceImpl moduleInstance) {
        if (this.fPostCreateHandlers != null) {
            for (PostCreateHandler handler : this.fPostCreateHandlers) {
                handler.created(moduleInstance);
            }
        }
    }

    private static void initProperties(ModuleInstanceImpl instance) {
        for (EStructuralFeature eStructuralFeature : instance.eClass().getEAllStructuralFeatures()) {
            if (!(eStructuralFeature.getEType() instanceof CollectionType)) continue;
            CollectionType collectionType = (CollectionType)eStructuralFeature.getEType();
            Collection currentValues = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)collectionType);
            instance.eSet(eStructuralFeature, currentValues);
        }
    }

    public static interface PostCreateHandler {
        public void created(ModuleInstance var1);
    }
}

