/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.label;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.label.DeclarativeLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEditorImageUtil;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class DefaultDescriptionLabelProvider
extends DeclarativeLabelProvider {
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private DefaultEditorImageUtil imageUtil;

    public Object image(IEObjectDescription element) {
        return this.image(element.getEClass());
    }

    public Object image(IResourceDescription element) {
        String fileName = element.getURI().lastSegment();
        return this.imageUtil.getDefaultEditorImageDescriptor(fileName);
    }

    public Object text(IEObjectDescription element) {
        return element.getQualifiedName() + " - " + element.getEClass().getName();
    }

    public Object text(IResourceDescription element) {
        Iterator<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(element.getURI()).iterator();
        if (storages.hasNext()) {
            IStorage storage = (IStorage)storages.next().getFirst();
            return storage.getFullPath().toString();
        }
        return null;
    }
}

