/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xtend2.xtend2.XtendField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectedExtensionMethodsFeaturesProvider
implements IFeaturesForTypeProvider {
    @Inject
    private FeatureOverridesService overridesService;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    private XtendField XtendField;

    public void setContext(XtendField XtendField2) {
        this.XtendField = XtendField2;
    }

    public Iterable<? extends JvmFeature> getFeaturesForType(JvmTypeReference type) {
        ArrayList result = Lists.newArrayList();
        JvmTypeReference typeReference = this.XtendField.getType();
        Iterable iterable = this.overridesService.getAllJvmFeatures(typeReference);
        for (JvmFeature jvmFeature : iterable) {
            JvmFormalParameter parameter;
            if (!(jvmFeature instanceof JvmOperation)) continue;
            JvmOperation jvmOperation = (JvmOperation)jvmFeature;
            EList parameters = jvmOperation.getParameters();
            if (jvmOperation.isStatic() || parameters.size() <= 0 || (parameter = (JvmFormalParameter)parameters.get(0)).getParameterType() == null || !this.isCompatibleType(type, parameter.getParameterType())) continue;
            result.add(jvmFeature);
        }
        return result;
    }

    protected boolean isCompatibleType(JvmTypeReference type, JvmTypeReference declaration) {
        if (declaration.getType() == type.getType()) {
            return true;
        }
        if (declaration.getType() instanceof JvmTypeParameter) {
            boolean upperBoundSeen = false;
            for (JvmTypeConstraint constraint : ((JvmTypeParameter)declaration.getType()).getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                upperBoundSeen = true;
                if (!this.typeConformanceComputer.isConformant(constraint.getTypeReference(), type, true)) continue;
                return true;
            }
            if (!upperBoundSeen && this.typeRefs.is(type, Object.class)) {
                return true;
            }
        }
        return false;
    }

    public boolean isExtensionProvider() {
        return true;
    }
}

