/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.parser.packrat.IBacktracker;
import org.eclipse.xtext.parser.packrat.internal.IFurtherParsable;
import org.eclipse.xtext.parser.packrat.internal.Marker;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedTokenVisitor;
import org.eclipse.xtext.parser.packrat.tokens.AlternativesToken;
import org.eclipse.xtext.parser.packrat.tokens.AssignmentToken;
import org.eclipse.xtext.parser.packrat.tokens.CompoundParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.ErrorToken;
import org.eclipse.xtext.parser.packrat.tokens.GroupToken;
import org.eclipse.xtext.parser.packrat.tokens.ParsedNonTerminal;
import org.eclipse.xtext.parser.packrat.tokens.ParsedNonTerminalEnd;
import org.eclipse.xtext.parser.packrat.tokens.ParsedTerminal;
import org.eclipse.xtext.parser.packrat.tokens.ParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.UnorderedGroupToken;

public class MarkerAwareBacktracker
implements IBacktracker {
    private final Marker marker;

    public MarkerAwareBacktracker(Marker marker) {
        this.marker = marker;
    }

    public IBacktracker.IBacktrackingResult skipPreviousToken() {
        return new NestedBacktrackingResult().skipPreviousToken();
    }

    protected class NestedBacktrackingResult
    extends AbstractParsedTokenVisitor
    implements IBacktracker.IBacktrackingResult,
    Marker.IMarkerVisitor {
        private final List<Marker> visitedMarkers;
        private final List<Marker> workingMarkers;
        private boolean result = false;
        private boolean lookup;
        private int stackSize;
        private final Set<AbstractParsedToken> markedTokens = new HashSet<AbstractParsedToken>(8);

        protected NestedBacktrackingResult() {
            this.visitedMarkers = new ArrayList<Marker>(4);
            this.workingMarkers = new ArrayList<Marker>(4);
        }

        public void commit() {
            if (this.workingMarkers.isEmpty()) {
                throw new IllegalStateException("Working marker may not be null");
            }
            Marker localMarker = MarkerAwareBacktracker.this.marker;
            int i = this.workingMarkers.size() - 1;
            while (i >= 0) {
                Marker workingMarker = this.workingMarkers.get(i);
                localMarker.replaceContent(workingMarker.getContent());
                localMarker.discardLastOffset();
                workingMarker.forget();
                localMarker = localMarker.getParent();
                --i;
            }
            this.workingMarkers.clear();
            this.markedTokens.clear();
        }

        public void discard() {
            for (AbstractParsedToken token : this.markedTokens) {
                token.setSkipped(false);
            }
            this.discardImpl();
        }

        private void discardImpl() {
            int i = this.workingMarkers.size() - 1;
            while (i >= 0) {
                Marker workingMarker = this.workingMarkers.get(i);
                workingMarker.forget();
                --i;
            }
            this.workingMarkers.clear();
            this.markedTokens.clear();
        }

        public boolean isSuccessful() {
            return this.result;
        }

        public IBacktracker.IBacktrackingResult skipPreviousToken() {
            this.discardImpl();
            this.init();
            Marker localMarker = MarkerAwareBacktracker.this.marker;
            List<AbstractParsedToken> content = null;
            int idx = -1;
            while (localMarker != null && !this.result && this.lookup) {
                this.visitedMarkers.add(localMarker);
                content = localMarker.getContent();
                idx = content.size() - 1;
                while (idx >= 0 && !this.result && this.lookup) {
                    content.get(idx).accept(this);
                    if (this.result) continue;
                    --idx;
                }
                if (this.result || !this.lookup) continue;
                localMarker = localMarker.getParent();
            }
            if (this.result && content != null) {
                Replayer replayer;
                Skipper skipper = new Skipper();
                idx = skipper.skip(idx);
                if (!this.visitedMarkers.isEmpty() && !(replayer = new Replayer()).replay(idx)) {
                    return this.skipPreviousToken();
                }
            }
            return this;
        }

        private void init() {
            this.visitedMarkers.clear();
            this.result = false;
            this.lookup = true;
            this.stackSize = 0;
        }

        public void visitAbstractParsedToken(AbstractParsedToken token) {
        }

        public void visitCompoundParsedToken(CompoundParsedToken token) {
            if (this.lookup && !token.isSkipped()) {
                if (this.stackSize == 0) {
                    this.lookup = false;
                } else {
                    --this.stackSize;
                    this.result = token.isOptional();
                }
            }
        }

        public void visitAlternativesToken(AlternativesToken token) {
            if (this.lookup && !token.isSkipped()) {
                if (this.stackSize == 0) {
                    this.lookup = false;
                } else if (token.canParseFurther()) {
                    this.result = true;
                } else {
                    super.visitAlternativesToken(token);
                }
            }
        }

        public void visitUnorderedGroupToken(UnorderedGroupToken token) {
            if (this.lookup && !token.isSkipped()) {
                if (this.stackSize == 0) {
                    this.lookup = false;
                } else if (token.canParseFurther()) {
                    this.result = true;
                } else {
                    super.visitUnorderedGroupToken(token);
                }
            }
        }

        public void visitParsedNonTerminal(ParsedNonTerminal token) {
            if (this.lookup && !token.isSkipped()) {
                if (this.stackSize == 0) {
                    this.lookup = false;
                } else {
                    --this.stackSize;
                    this.result = token.isOptional();
                }
            }
        }

        public void visitParsedNonTerminalEnd(ParsedNonTerminalEnd token) {
            if (this.lookup && !token.isSkipped()) {
                ++this.stackSize;
            }
        }

        public void visitCompoundParsedTokenEnd(CompoundParsedToken.End token) {
            if (!token.isSkipped()) {
                ++this.stackSize;
            }
        }

        public void visitParsedTerminal(ParsedTerminal token) {
            if (!token.isHidden() && !token.isSkipped() && token.getGrammarElement() instanceof AbstractElement) {
                this.result = token.isOptional();
            }
        }

        public void visitMarker(Marker marker) {
            throw new IllegalStateException("Marker may not be content of other markers.");
        }

        private final class Replayer
        extends AbstractParsedTokenVisitor
        implements Marker.IMarkerVisitor {
            private boolean first;
            private int idx;
            private int stackSize = 0;
            private ParsedToken replayToken;
            private List<AbstractParsedToken> contents;
            private Marker workingMarker;

            private Replayer() {
            }

            public boolean replay(int idx) {
                this.idx = idx;
                this.first = true;
                Marker markerToFork = (Marker)NestedBacktrackingResult.this.visitedMarkers.get(NestedBacktrackingResult.this.visitedMarkers.size() - 1);
                this.workingMarker = markerToFork.forkAfterSkipped(idx);
                NestedBacktrackingResult.this.workingMarkers.add(this.workingMarker);
                int offset = this.workingMarker.getOffset();
                int i = 0;
                while (i < this.workingMarker.getContent().size()) {
                    AbstractParsedToken token = this.workingMarker.getContent().get(i);
                    if (!token.isSkipped()) {
                        offset += token.getLength();
                    }
                    ++i;
                }
                this.workingMarker.getInput().setOffset(offset);
                boolean replaySuccessful = true;
                while (!NestedBacktrackingResult.this.visitedMarkers.isEmpty() && replaySuccessful) {
                    this.contents = ((Marker)NestedBacktrackingResult.this.visitedMarkers.get(NestedBacktrackingResult.this.visitedMarkers.size() - 1)).getContent();
                    while (replaySuccessful && this.replay()) {
                        if (this.replayToken == null) continue;
                        Marker localMarker = (Marker)this.workingMarker.getClient().mark();
                        try {
                            IFurtherParsable continuedParsable;
                            replaySuccessful = this.first && this.replayToken instanceof IFurtherParsable ? (continuedParsable = (IFurtherParsable)((Object)this.replayToken)).getSource().parseFurther(continuedParsable) == -2 : this.replayToken.getSource().parseAgain(this.replayToken) == -2;
                            this.first = false;
                        }
                        catch (Exception e) {
                            throw new WrappedException(e);
                        }
                        if (replaySuccessful) {
                            localMarker.commit();
                        } else {
                            localMarker.rollback();
                        }
                        localMarker = null;
                    }
                    if (!replaySuccessful) continue;
                    NestedBacktrackingResult.this.visitedMarkers.remove(NestedBacktrackingResult.this.visitedMarkers.size() - 1);
                    if (NestedBacktrackingResult.this.visitedMarkers.isEmpty()) continue;
                    this.workingMarker = (Marker)this.workingMarker.getClient().mark();
                    NestedBacktrackingResult.this.workingMarkers.add(this.workingMarker);
                    this.idx = 0;
                }
                return replaySuccessful;
            }

            public boolean replay() {
                if (this.idx >= this.contents.size()) {
                    return false;
                }
                this.next();
                return this.replayToken != null;
            }

            private void next() {
                this.replayToken = null;
                while (this.idx < this.contents.size() && (this.replayToken == null || this.stackSize != 0)) {
                    this.contents.get(this.idx).accept(this);
                    ++this.idx;
                }
            }

            public void visitCompoundParsedToken(CompoundParsedToken token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.replayToken = token;
                    }
                    ++this.stackSize;
                }
            }

            public void visitAlternativesTokenEnd(AlternativesToken.End token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.workingMarker.accept(new AlternativesToken.End(this.workingMarker.getInput().getOffset(), token.getAlternative()));
                    } else {
                        --this.stackSize;
                    }
                }
            }

            public void visitUnorderedGroupTokenEnd(UnorderedGroupToken.End token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.workingMarker.accept(new UnorderedGroupToken.End(this.workingMarker.getInput().getOffset()));
                    } else {
                        --this.stackSize;
                    }
                }
            }

            public void visitAssignmentTokenEnd(AssignmentToken.End token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.workingMarker.accept(new AssignmentToken.End(this.workingMarker.getInput().getOffset()));
                    } else {
                        --this.stackSize;
                    }
                }
            }

            public void visitGroupTokenEnd(GroupToken.End token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.workingMarker.accept(new GroupToken.End(this.workingMarker.getInput().getOffset()));
                    } else {
                        --this.stackSize;
                    }
                }
            }

            public void visitParsedNonTerminal(ParsedNonTerminal token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.replayToken = token;
                    }
                    ++this.stackSize;
                }
            }

            public void visitParsedNonTerminalEnd(ParsedNonTerminalEnd token) {
                if (!token.isSkipped()) {
                    if (this.stackSize == 0) {
                        this.workingMarker.accept(new ParsedNonTerminalEnd(this.workingMarker.getInput().getOffset(), token.getFeature(), token.isMany(), token.isDatatype(), token.isBoolean()));
                    } else {
                        --this.stackSize;
                    }
                }
            }

            public void visitParsedToken(ParsedToken token) {
                if (!token.isSkipped() && this.replayToken == null) {
                    this.replayToken = token;
                }
            }

            public void visitMarker(Marker marker) {
                throw new IllegalStateException("Marker may not be content of other markers.");
            }
        }

        private final class Skipper
        extends AbstractParsedTokenVisitor
        implements Marker.IMarkerVisitor {
            private boolean continueSkip = true;
            private int stackSize = 0;
            private boolean first;

            private Skipper() {
            }

            public int skip(int idx) {
                int i = idx;
                this.first = true;
                while (!NestedBacktrackingResult.this.visitedMarkers.isEmpty() && this.continueSkip) {
                    Marker localMarker = (Marker)NestedBacktrackingResult.this.visitedMarkers.get(NestedBacktrackingResult.this.visitedMarkers.size() - 1);
                    List<AbstractParsedToken> content = localMarker.getContent();
                    while (i < content.size() && this.continueSkip) {
                        content.get(i).accept(this);
                        this.first = false;
                        if (!this.continueSkip) continue;
                        ++i;
                    }
                    if (!this.continueSkip) continue;
                    NestedBacktrackingResult.this.visitedMarkers.remove(NestedBacktrackingResult.this.visitedMarkers.size() - 1);
                }
                return i;
            }

            public void visitAbstractParsedToken(AbstractParsedToken token) {
            }

            public void visitCompoundParsedToken(CompoundParsedToken token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                    ++this.stackSize;
                }
            }

            public void visitAlternativesToken(AlternativesToken token) {
                if (!token.isSkipped()) {
                    if (this.first && token.canParseFurther()) {
                        this.continueSkip = false;
                    } else {
                        super.visitAlternativesToken(token);
                    }
                }
            }

            public void visitUnorderedGroupToken(UnorderedGroupToken token) {
                if (!token.isSkipped()) {
                    if (this.first && token.canParseFurther()) {
                        this.continueSkip = false;
                    } else {
                        super.visitUnorderedGroupToken(token);
                    }
                }
            }

            public void visitCompoundParsedTokenEnd(CompoundParsedToken.End token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                    --this.stackSize;
                    this.continueSkip = this.stackSize != 0;
                }
            }

            public void visitParsedTerminal(ParsedTerminal token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                    this.continueSkip = this.stackSize != 0;
                }
            }

            public void visitParsedNonTerminal(ParsedNonTerminal token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                    ++this.stackSize;
                }
            }

            public void visitParsedNonTerminalEnd(ParsedNonTerminalEnd token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                    --this.stackSize;
                    this.continueSkip = this.stackSize != 0;
                }
            }

            public void visitErrorToken(ErrorToken token) {
                if (!token.isSkipped()) {
                    NestedBacktrackingResult.this.markedTokens.add(token);
                    token.setSkipped(true);
                }
            }

            public void visitMarker(Marker marker) {
                throw new IllegalStateException("Marker may not be content of other markers.");
            }
        }
    }
}

