/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.edit;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.xtend.core.formatting.OrganizeImports;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OrganizeImportsHandler
extends AbstractHandler {
    @Inject
    private OrganizeImports organizeImports;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            IXtextDocument document = editor.getDocument();
            this.doOrganizeImports(document);
        }
        return null;
    }

    public void doOrganizeImports(IXtextDocument document) {
        Pair result = (Pair)document.readOnly((IUnitOfWork)new IUnitOfWork<Pair<Region, String>, XtextResource>(){

            public Pair<Region, String> exec(XtextResource state) throws Exception {
                TextRegion computeRegion = OrganizeImportsHandler.this.organizeImports.computeRegion(state);
                if (computeRegion == null) {
                    return null;
                }
                String organizedImportSection = OrganizeImportsHandler.this.organizeImports.getOrganizedImportSection(state);
                if (organizedImportSection == null) {
                    return null;
                }
                return Tuples.create((Object)new Region(computeRegion.getOffset(), computeRegion.getLength()), (Object)organizedImportSection);
            }
        });
        if (result == null) {
            return;
        }
        try {
            String string = document.get(((Region)result.getFirst()).getOffset(), ((Region)result.getFirst()).getLength());
            if (!string.equals(result.getSecond())) {
                document.replace(((Region)result.getFirst()).getOffset(), ((Region)result.getFirst()).getLength(), (String)result.getSecond());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

