/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XtypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Closures {
    @Inject
    private XtypeFactory xtypeFactory = XtypeFactory.eINSTANCE;
    @Inject
    private TypesFactory typesFactory = TypesFactory.eINSTANCE;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private IRawTypeHelper rawTypeHelper;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;

    public JvmTypeReference getCompatibleFunctionType(JvmTypeReference original, final boolean instanceContext, final boolean rawType) {
        if (original == null) {
            return null;
        }
        JvmTypeReference result = (JvmTypeReference)new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

            public JvmTypeReference doVisitTypeReference(JvmTypeReference reference) {
                return null;
            }

            protected JvmTypeReference handleNullReference() {
                return null;
            }

            public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                JvmOperation operation;
                JvmType type = reference.getType();
                if (type instanceof JvmGenericType && !type.eIsProxy() && ((JvmGenericType)type).isInterface() && (operation = Closures.this.findImplementingOperation((JvmTypeReference)reference, type.eResource())) != null) {
                    JvmParameterizedTypeReference result = null;
                    boolean procedure = Closures.this.typeRefs.is(operation.getReturnType(), Void.TYPE);
                    if (rawType) {
                        result = Closures.this.createRawFunctionTypeRef((EObject)operation, operation.getParameters().size(), procedure);
                    } else {
                        if (type instanceof JvmTypeParameterDeclarator && !((JvmTypeParameterDeclarator)type).getTypeParameters().isEmpty() && reference.getArguments().isEmpty()) {
                            return Closures.this.createRawFunctionTypeRef((EObject)operation, operation.getParameters().size(), procedure);
                        }
                        final ITypeArgumentContext argumentContext = Closures.this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest((JvmTypeReference)reference));
                        List parameterTypes = Lists.transform((List)operation.getParameters(), (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

                            public JvmTypeReference apply(JvmFormalParameter from) {
                                if (from != null) {
                                    JvmTypeReference result = argumentContext.getLowerBound(from.getParameterType());
                                    return result;
                                }
                                return null;
                            }
                        });
                        JvmTypeReference returnType = argumentContext.getUpperBound(operation.getReturnType(), (Notifier)operation);
                        result = Closures.this.createFunctionTypeRef((EObject)type, parameterTypes, returnType, instanceContext);
                    }
                    return result;
                }
                return null;
            }

            public JvmTypeReference doVisitDelegateTypeReference(JvmDelegateTypeReference reference) {
                JvmTypeReference result = (JvmTypeReference)super.doVisitDelegateTypeReference(reference);
                if (result != reference.getDelegate()) {
                    return result;
                }
                return reference;
            }

            public JvmTypeReference doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                JvmCompoundTypeReference result = null;
                EList components = reference.getReferences();
                int recent = -1;
                boolean wasEquivalent = false;
                int i = 0;
                while (i < components.size()) {
                    JvmTypeReference component = (JvmTypeReference)components.get(i);
                    JvmTypeReference equivalent = Closures.this.getCompatibleFunctionType(component, instanceContext, rawType);
                    wasEquivalent |= equivalent != null;
                    if (equivalent != null && component != equivalent) {
                        if (result == null) {
                            result = (JvmCompoundTypeReference)EcoreUtil.create((EClass)reference.eClass());
                        }
                        int j = recent + 1;
                        while (j < i) {
                            JvmDelegateTypeReference delegate = Closures.this.typesFactory.createJvmDelegateTypeReference();
                            delegate.setDelegate((JvmTypeReference)components.get(j));
                            result.getReferences().add((Object)delegate);
                            ++j;
                        }
                        result.getReferences().add((Object)equivalent);
                        recent = i;
                    }
                    ++i;
                }
                if (wasEquivalent) {
                    if (result != null) {
                        return result;
                    }
                    return reference;
                }
                return null;
            }

            public JvmTypeReference doVisitSpecializedTypeReference(JvmSpecializedTypeReference reference) {
                if (reference instanceof XFunctionTypeRef) {
                    return reference;
                }
                JvmTypeReference result = (JvmTypeReference)super.doVisitSpecializedTypeReference(reference);
                if (result != reference.getEquivalent()) {
                    return result;
                }
                return reference;
            }
        }.visit(original);
        return result;
    }

    public JvmOperation findImplementingOperation(JvmTypeReference closureType, Resource resource) {
        List rawTypes = this.rawTypeHelper.getAllRawTypes(closureType, resource);
        for (JvmType rawType : rawTypes) {
            if (!(rawType instanceof JvmDeclaredType)) continue;
            Iterable features = Iterables.filter((Iterable)((JvmDeclaredType)rawType).getAllFeatures(), JvmOperation.class);
            JvmOperation result = null;
            for (JvmOperation op : features) {
                if (!this.isValidFunction(op)) continue;
                if (result == null) {
                    result = op;
                    continue;
                }
                result = null;
                break;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isValidFunction(JvmOperation op) {
        if (op.getVisibility() == JvmVisibility.PUBLIC) {
            if (Object.class.getName().equals(op.getDeclaringType().getIdentifier())) {
                return false;
            }
            String name = op.getSimpleName();
            if (name.equals("toString") && op.getParameters().isEmpty()) {
                return false;
            }
            if (name.equals("equals") && op.getParameters().size() == 1) {
                return false;
            }
            return !name.equals("hashCode") || !op.getParameters().isEmpty();
        }
        return false;
    }

    public JvmParameterizedTypeReference createRawFunctionTypeRef(EObject context, int parameterCount, boolean procedure) {
        JvmParameterizedTypeReference result = this.typesFactory.createJvmParameterizedTypeReference();
        String simpleClassName = String.valueOf(procedure ? "Procedure" : "Function") + Math.min(6, parameterCount);
        Class<?> loadFunctionClass = this.loadFunctionClass(simpleClassName, procedure);
        JvmType declaredType = this.typeRefs.findDeclaredType(loadFunctionClass, (Notifier)context);
        if (declaredType == null) {
            return null;
        }
        result.setType(declaredType);
        return result;
    }

    public JvmTypeReference createFunctionTypeRef(EObject context, List<JvmTypeReference> parameterTypes, JvmTypeReference returnType, boolean instanceContext) {
        XFunctionTypeRef result = this.xtypeFactory.createXFunctionTypeRef();
        result.setInstanceContext(instanceContext);
        for (JvmTypeReference parameterType : parameterTypes) {
            if (parameterType != null && parameterType.eContainer() == null) {
                result.getParamTypes().add((Object)parameterType);
                continue;
            }
            JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
            delegate.setDelegate(parameterType);
            result.getParamTypes().add((Object)delegate);
        }
        if (returnType != null && returnType.eContainer() == null) {
            result.setReturnType(returnType);
        } else {
            JvmDelegateTypeReference delegate = this.typesFactory.createJvmDelegateTypeReference();
            delegate.setDelegate(returnType);
            result.setReturnType((JvmTypeReference)delegate);
        }
        JvmType type = result.getType();
        JvmType resolved = (JvmType)EcoreUtil.resolve((EObject)type, (EObject)context);
        if (type != resolved) {
            result.setType(resolved);
        }
        return result;
    }

    private Class<?> loadFunctionClass(String simpleFunctionName, boolean procedure) {
        try {
            if (!procedure) {
                return Functions.class.getClassLoader().loadClass(String.valueOf(Functions.class.getCanonicalName()) + "$" + simpleFunctionName);
            }
            return Procedures.class.getClassLoader().loadClass(String.valueOf(Procedures.class.getCanonicalName()) + "$" + simpleFunctionName);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException((Exception)e);
        }
    }
}

