/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.AbstractConformanceVisitor;
import org.eclipse.xtext.xbase.typesystem.conformance.AnyTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.ArrayConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.FunctionTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.MultiTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.ParameterizedTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.SynonymConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.UnboundConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.UnknownTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.WildcardConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TypeConformanceStrategySelector
extends AbstractConformanceVisitor<LightweightTypeReference> {
    private final TypeConformanceComputer conformanceComputer;
    private final TypeConformanceStrategy<AnyTypeReference> anyTypeDispatcher;
    private final TypeConformanceStrategy<ArrayTypeReference> arrayTypeDispatcher;
    private final TypeConformanceStrategy<CompoundTypeReference> multiTypeDispatcher;
    private final TypeConformanceStrategy<CompoundTypeReference> synonymTypeDispatcher;
    private final TypeConformanceStrategy<ParameterizedTypeReference> parameterizedTypeDispatcher;
    private final TypeConformanceStrategy<FunctionTypeReference> functionTypeDispatcher;
    private final TypeConformanceStrategy<UnboundTypeReference> unboundTypeDispatcher;
    private final TypeConformanceStrategy<UnknownTypeReference> unknownTypeDispatcher;
    private final TypeConformanceStrategy<WildcardTypeReference> wildcardTypeDispatcher;

    public TypeConformanceStrategySelector(TypeConformanceComputer conformanceComputer) {
        this.conformanceComputer = conformanceComputer;
        this.anyTypeDispatcher = this.createAnyTypeDispatcher();
        this.arrayTypeDispatcher = this.createArrayTypeDispatcher();
        this.functionTypeDispatcher = this.createFunctionTypeDispatcher();
        this.multiTypeDispatcher = this.createMultiTypeDispatcher();
        this.synonymTypeDispatcher = this.createSynonymTypeDispatcher();
        this.parameterizedTypeDispatcher = this.createParameterizedTypeDispatcher();
        this.unboundTypeDispatcher = this.createUnboundTypeDispatcher();
        this.unknownTypeDispatcher = this.createUnknownTypeDispatcher();
        this.wildcardTypeDispatcher = this.createWildcardTypeDispatcher();
    }

    protected <T extends LightweightTypeReference> TypeConformanceComputationArgument.Internal<T> copyArgument(T t, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return TypeConformanceComputationArgument.Internal.create(t, param.rawType, param.asTypeArgument, param.allowPrimitiveConversion, param.allowPrimitiveWidening, param.unboundComputationAddsHints, param.allowSynonyms);
    }

    @Override
    protected TypeConformanceResult doVisitAnyTypeReference(AnyTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.anyTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitUnknownTypeReference(UnknownTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.unknownTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitArrayTypeReference(ArrayTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.arrayTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitMultiTypeReference(CompoundTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.multiTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitFunctionTypeReference(FunctionTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.functionTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitParameterizedTypeReference(ParameterizedTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.parameterizedTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitSynonymTypeReference(CompoundTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.synonymTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitUnboundTypeReference(UnboundTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.unboundTypeDispatcher, this.copyArgument(reference, param));
    }

    @Override
    protected TypeConformanceResult doVisitWildcardTypeReference(WildcardTypeReference reference, TypeConformanceComputationArgument.Internal<LightweightTypeReference> param) {
        return (TypeConformanceResult)((LightweightTypeReference)param.reference).accept(this.wildcardTypeDispatcher, this.copyArgument(reference, param));
    }

    protected TypeConformanceStrategy<AnyTypeReference> createAnyTypeDispatcher() {
        return new AnyTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<ArrayTypeReference> createArrayTypeDispatcher() {
        return new ArrayConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<CompoundTypeReference> createMultiTypeDispatcher() {
        return new MultiTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<ParameterizedTypeReference> createParameterizedTypeDispatcher() {
        return new ParameterizedTypeConformanceStrategy<ParameterizedTypeReference>(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<FunctionTypeReference> createFunctionTypeDispatcher() {
        return new FunctionTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<CompoundTypeReference> createSynonymTypeDispatcher() {
        return new SynonymConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<UnboundTypeReference> createUnboundTypeDispatcher() {
        return new UnboundConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<UnknownTypeReference> createUnknownTypeDispatcher() {
        return new UnknownTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<WildcardTypeReference> createWildcardTypeDispatcher() {
        return new WildcardConformanceStrategy(this.conformanceComputer);
    }
}

