/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.Mapping;
import org.eclipse.emf.mwe2.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.GenModelAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreGeneratorFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(EcoreGeneratorFragment.class);
    private static final String MODEL_PLUGIN_ID = "modelPluginID";
    private String basePackage = null;
    private String editDirectory = null;
    private String editorDirectory = null;
    private String editorPluginID = null;
    private String editPluginID = null;
    private boolean generateEdit = false;
    private boolean generateEditor = false;
    private String genModel = null;
    private String javaModelDirectory = null;
    private String modelPluginID = null;
    @Deprecated
    private String referencedGenModels;
    private boolean skipGenerate = false;
    private String xmiModelDirectory = null;
    private String fileExtensions = null;
    private GenRuntimeVersion emfRuntimeVerison;

    public EcoreGeneratorFragment() {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("genmodel")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
    }

    protected Resource createResourceForEPackages(Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs, ResourceSet rs) {
        URI ecoreFileUri = this.getEcoreFileUri(grammar, ctx);
        Resource existing = rs.getResource(ecoreFileUri = EcoreGeneratorFragment.toPlatformResourceURI(ecoreFileUri), false);
        if (existing != null) {
            existing.unload();
            rs.getResources().remove((Object)existing);
        }
        Resource ecoreFile = rs.createResource(ecoreFileUri, "");
        ecoreFile.getContents().addAll(packs);
        return ecoreFile;
    }

    protected void doGenerate(GenModel genModel) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                if (this.jControlModel == null) {
                    this.jControlModel = new JControlModel();
                    this.jControlModel.initialize(null, this.options.mergeRulesURI);
                }
                return this.jControlModel;
            }
        };
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)new CvsIdFilteringGeneratorAdapterFactoryDescriptor());
        generator.setInput((Object)genModel);
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        if (diagnostic.getSeverity() != 0) {
            log.info((Object)diagnostic);
        }
        if (this.isGenerateEdit() && (editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editDiag);
        }
        if (this.isGenerateEditor() && (editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editorDiag);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        try {
            this.registerReferencedGenModels();
            if (!this.hasGeneratedMetamodel(grammar)) {
                return;
            }
            Grammar clonedGrammar = this.cloneGrammarIntoNewResourceSet(grammar);
            ResourceSet workingResourceSet = clonedGrammar.eResource().getResourceSet();
            List<EPackage> generatedPackages = this.getGeneratedEPackages(clonedGrammar);
            this.registerUsedGenModel(workingResourceSet.getURIConverter());
            if (!generatedPackages.isEmpty()) {
                Map<String, EPackage> usedEPackages = this.findAllUsedEPackages(generatedPackages);
                Map<String, EPackage> loadedEPackages = this.findEPackagesInGenPackages(usedEPackages.keySet(), workingResourceSet);
                Map<EObject, EObject> eNamedElementMapping = this.createENamedElementMapping(usedEPackages, loadedEPackages);
                this.replaceReferencesInGeneratedPackages(generatedPackages, eNamedElementMapping);
                Resource ePackageResource = this.createResourceForEPackages(clonedGrammar, ctx, generatedPackages, workingResourceSet);
                if (!this.skipGenerate) {
                    GenModel genModel = this.getSaveAndReconcileGenModel(workingResourceSet, clonedGrammar, ctx, generatedPackages);
                    genModel.reconcile();
                    this.doGenerate(genModel);
                    if (this.basePackage == null) {
                        this.basePackage = ((GenPackage)genModel.getGenPackages().get(0)).getBasePackage();
                    }
                    super.generate(clonedGrammar, ctx);
                }
                this.saveResource(ePackageResource);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void saveResource(Resource resource) throws IOException {
        Map<String, ToPlatformResourceDeresolvingURIHandler> saveOptions = Collections.singletonMap("URI_HANDLER", new ToPlatformResourceDeresolvingURIHandler());
        resource.save(saveOptions);
    }

    private void registerUsedGenModel(URIConverter converter) {
        if (this.genModel == null) {
            return;
        }
        URI genModelUri = URI.createURI((String)this.genModel);
        if (converter.exists(genModelUri = EcoreGeneratorFragment.toPlatformResourceURI(genModelUri), null)) {
            try {
                new GenModelHelper().registerGenModel((ResourceSet)new XtextResourceSet(), genModelUri);
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void replaceReferencesInGeneratedPackages(List<EPackage> generatedPackages, Map<EObject, EObject> eNamedElementMapping) {
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)current.eClass().getEAllStructuralFeatures()).crossReferences();
            if (crossReferenceFeatures == null) continue;
            EStructuralFeature[] eStructuralFeatureArray = crossReferenceFeatures;
            int n = crossReferenceFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature crossReferenceFeature = eStructuralFeatureArray[n2];
                if (crossReferenceFeature.isChangeable()) {
                    EReference reference = (EReference)crossReferenceFeature;
                    if (reference.isMany()) {
                        List values = (List)current.eGet((EStructuralFeature)reference);
                        int i = 0;
                        while (i < values.size()) {
                            EObject value = (EObject)values.get(i);
                            if (eNamedElementMapping.containsKey(value)) {
                                EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)eNamedElementMapping.get(value));
                            }
                            ++i;
                        }
                    } else {
                        EObject value = (EObject)current.eGet((EStructuralFeature)reference);
                        if (eNamedElementMapping.containsKey(value)) {
                            EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)eNamedElementMapping.get(value));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private Map<EObject, EObject> createENamedElementMapping(Map<String, EPackage> usedEPackages, Map<String, EPackage> loadedEPackages) {
        HashMap result = Maps.newHashMap();
        for (String nsURI : usedEPackages.keySet()) {
            EPackage usedEPackage = usedEPackages.get(nsURI);
            EPackage loadedEPackage = loadedEPackages.get(nsURI);
            this.putMappingData(result, usedEPackage, loadedEPackage);
        }
        return result;
    }

    private void putMappingData(Map<EObject, EObject> result, EPackage usedEPackage, EPackage loadedEPackage) {
        if (loadedEPackage != null && usedEPackage != loadedEPackage) {
            result.put((EObject)usedEPackage, (EObject)loadedEPackage);
            for (EClassifier usedClassifier : usedEPackage.getEClassifiers()) {
                EClassifier loadedClassifier = loadedEPackage.getEClassifier(usedClassifier.getName());
                if (loadedClassifier == null) {
                    throw new RuntimeException("Cannot find classifier '" + usedClassifier.getName() + "' in loaded EPackage from " + loadedEPackage.eResource().getURI());
                }
                result.put((EObject)usedClassifier, (EObject)loadedClassifier);
            }
            block1: for (EPackage usedNestedPackage : usedEPackage.getESubpackages()) {
                for (EPackage loadedNestedPackage : loadedEPackage.getESubpackages()) {
                    if (!usedNestedPackage.getName().equals(loadedNestedPackage.getName())) continue;
                    this.putMappingData(result, usedNestedPackage, loadedNestedPackage);
                    continue block1;
                }
            }
        }
    }

    private Map<String, EPackage> findAllUsedEPackages(List<EPackage> generatedPackages) {
        HashMap result = Maps.newHashMap();
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            for (EObject referenced : current.eCrossReferences()) {
                EPackage referencedPackage;
                if (referenced.eIsProxy()) {
                    throw new RuntimeException("Unresolved proxy: " + referenced + " in " + current);
                }
                if (!(referenced instanceof EClassifier) || generatedPackages.contains(referencedPackage = ((EClassifier)referenced).getEPackage())) continue;
                result.put(referencedPackage.getNsURI(), referencedPackage);
            }
        }
        return result;
    }

    private Map<String, EPackage> findEPackagesInGenPackages(Set<String> packageNsURIs, ResourceSet resourceSet) {
        HashMap result = Maps.newHashMap();
        block0: for (String nsURI : packageNsURIs) {
            Resource resource = GenModelAccess.getGenModelResource(null, nsURI, resourceSet);
            if (resource == null) continue;
            for (EObject content : resource.getContents()) {
                if (!(content instanceof GenModel)) continue;
                GenModel loadedGenModel = (GenModel)content;
                GenPackage genPackage = this.findGenPackageByNsURI(loadedGenModel, nsURI);
                result.put(nsURI, genPackage.getEcorePackage());
                continue block0;
            }
        }
        return result;
    }

    private GenPackage findGenPackageByNsURI(GenModel genModel, String nsURI) {
        List allGenPackages = genModel.getAllGenUsedAndStaticGenPackagesWithClassifiers();
        for (GenPackage genPackage : allGenPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            if (ecorePackage == null || ecorePackage.eIsProxy()) {
                throw new RuntimeException("Unresolved proxy: " + ecorePackage + " in " + genModel.eResource().getURI());
            }
            if (!nsURI.equals(ecorePackage.getNsURI())) continue;
            return genPackage;
        }
        throw new RuntimeException("No GenPackage for NsURI " + nsURI + " found in " + genModel.eResource().getURI());
    }

    private boolean hasGeneratedMetamodel(Grammar grammar) {
        Iterable generatedMetamodels = Iterables.filter((Iterable)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        return generatedMetamodels.iterator().hasNext();
    }

    private Grammar cloneGrammarIntoNewResourceSet(Grammar original) {
        Resource originalResource = original.eResource();
        ResourceSet clonedResourceSet = EcoreUtil2.clone((ResourceSet)new XtextResourceSet(), (ResourceSet)originalResource.getResourceSet());
        Resource clonedResource = clonedResourceSet.getResource(originalResource.getURI(), false);
        Grammar clonedGrammar = (Grammar)clonedResource.getContents().get(0);
        return clonedGrammar;
    }

    private static URI toPlatformResourceURI(URI uri) {
        if (uri.isPlatform()) {
            return uri;
        }
        Map map = EcorePlugin.getPlatformResourceMap();
        for (Map.Entry entries : map.entrySet()) {
            URI newPrefix = URI.createURI((String)("platform:/resource/" + (String)entries.getKey() + "/"));
            URI uri2 = uri.replacePrefix((URI)entries.getValue(), newPrefix);
            if (uri2 == null) continue;
            return uri2;
        }
        return uri;
    }

    @Deprecated
    protected List<GenPackage> loadReferencedGenModels(ResourceSet rs) {
        ArrayList result = Lists.newArrayList();
        if (this.getReferencedGenModels() != null) {
            String[] stringArray = this.getReferencedGenModels().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    Resource resource = rs.getResource(URI.createURI((String)uri.trim()), true);
                    GenModel genmodel = (GenModel)resource.getContents().get(0);
                    EList genPackages = genmodel.getGenPackages();
                    for (GenPackage genPackage : genPackages) {
                        genPackage.getEcorePackage().getEClassifiers();
                        result.add(genPackage);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Couldn't find genmodel for uri '" + uri + "'"));
                    throw new WrappedException(e);
                }
                ++n2;
            }
        }
        return result;
    }

    protected Set<EPackage> getReferencedEPackages(List<EPackage> packs) {
        HashSet result = Sets.newHashSet();
        for (EPackage pkg : packs) {
            TreeIterator it = pkg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                for (EObject crossRef : obj.eCrossReferences()) {
                    if (crossRef.eIsProxy()) {
                        log.error((Object)("Proxy '" + ((InternalEObject)crossRef).eProxyURI() + "' could not be resolved"));
                        continue;
                    }
                    EPackage p = (EPackage)EcoreUtil2.getContainerOfType((EObject)crossRef, EPackage.class);
                    if (p == null) continue;
                    result.add(p);
                }
            }
        }
        for (EPackage pkg : packs) {
            result.remove(pkg);
        }
        result.remove(EcorePackage.eINSTANCE);
        result.remove(XMLTypePackage.eINSTANCE);
        result.remove(XMLNamespacePackage.eINSTANCE);
        return result;
    }

    protected List<GenPackage> getGenPackagesForPackages(GenModel existingGenModel, Collection<EPackage> packs) {
        ArrayList result = Lists.newArrayList();
        for (EPackage pkg : packs) {
            boolean found = false;
            for (GenPackage gp : existingGenModel.getGenPackages()) {
                if (gp.getEcorePackage() == null || gp.getEcorePackage().getNsURI() == null || !gp.getEcorePackage().getNsURI().equals(pkg.getNsURI())) continue;
                found = true;
            }
            if (found) continue;
            result.add(GenModelAccess.getGenPackage(pkg, existingGenModel.eResource().getResourceSet()));
        }
        Collections.sort(result, new Comparator<GenPackage>(){

            @Override
            public int compare(GenPackage o1, GenPackage o2) {
                return EcoreUtil.getURI((EObject)o1).toString().compareTo(EcoreUtil.getURI((EObject)o2).toString());
            }
        });
        return result;
    }

    public String getBasePackage(Grammar g) {
        if (this.basePackage == null) {
            return GrammarUtil.getNamespace((Grammar)g);
        }
        return this.basePackage;
    }

    protected URI getEcoreFileUri(Grammar grammar, XpandExecutionContext ctx) {
        String javaPath = this.getJavaModelDirectory(ctx);
        String xmiPath = this.getXmiModelDirectory(grammar, javaPath);
        try {
            String prefix = String.valueOf(new File(xmiPath).getCanonicalPath()) + File.separator + this.getModelName(grammar);
            URI ecoreFileUri = URI.createFileURI((String)(String.valueOf(prefix) + ".ecore"));
            return ecoreFileUri;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't compute canonical path for " + new File(xmiPath).getAbsolutePath());
        }
    }

    public String getEditDirectory(XpandExecutionContext ctx) {
        if (this.editDirectory == null || "".equals(this.editDirectory)) {
            this.editDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".edit/src";
        }
        return this.editDirectory;
    }

    public String getEditorDirectory(XpandExecutionContext ctx) {
        if (this.editorDirectory == null || "".equals(this.editorDirectory)) {
            this.editorDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".editor/src";
        }
        return this.editorDirectory;
    }

    protected String getEditorPluginID(XpandExecutionContext ctx) {
        if ((this.editorPluginID == null || "".equals(this.editorPluginID)) && this.getModelPluginID(ctx) != null) {
            this.editorPluginID = String.valueOf(this.getModelPluginID(ctx)) + ".editor";
        }
        return this.editorPluginID;
    }

    public String getEditPluginID(XpandExecutionContext ctx) {
        if ((this.editPluginID == null || "".equals(this.editPluginID)) && this.getModelPluginID(ctx) != null) {
            this.editPluginID = String.valueOf(this.getModelPluginID(ctx)) + ".edit";
        }
        return this.editPluginID;
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        List typeSelect = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        LinkedHashSet<String> exportedPackages = new LinkedHashSet<String>();
        for (GeneratedMetamodel generatedMetamodel : typeSelect) {
            String modelPackage = Strings.skipLastToken((String)this.getGeneratedEPackageName(grammar, generatedMetamodel.getEPackage()), (String)".");
            exportedPackages.add(modelPackage);
            exportedPackages.add(String.valueOf(modelPackage) + ".impl");
            exportedPackages.add(String.valueOf(modelPackage) + ".util");
        }
        return exportedPackages.toArray(new String[exportedPackages.size()]);
    }

    public String getGeneratedEPackageName(Grammar g, EPackage pack) {
        return String.valueOf(this.getBasePackage(g)) + "." + pack.getName() + "." + Strings.toFirstUpper((String)pack.getName()) + "Package";
    }

    protected List<EPackage> getGeneratedEPackages(Grammar grammar) {
        List list = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        List packs = EcoreUtil2.collect((Collection)list, (int)0, EPackage.class);
        return packs;
    }

    protected GenModel getGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs) {
        GenModel genModel;
        URI genModelUri = this.getGenModelUri(grammar, ctx);
        Resource resource = rs.getResource(genModelUri = EcoreGeneratorFragment.toPlatformResourceURI(genModelUri), false);
        if (resource != null) {
            resource.unload();
            rs.getResources().remove((Object)resource);
        }
        Resource genModelFile = rs.createResource(genModelUri, "");
        if (rs.getURIConverter().exists(genModelUri, null)) {
            try {
                genModelFile.load(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
            genModel = genModelUri.hasFragment() ? (GenModel)genModelFile.getEObject(genModelUri.fragment()) : (GenModel)genModelFile.getContents().get(0);
        } else {
            genModel = GenModelPackage.eINSTANCE.getGenModelFactory().createGenModel();
            genModel.setModelDirectory(this.toGenModelProjectPath(this.getJavaModelDirectory(ctx)));
            genModel.setModelName(this.getModelName(grammar));
            genModel.setModelPluginID(this.getModelPluginID(ctx));
            genModel.setEditDirectory(this.toGenModelProjectPath(this.getEditDirectory(ctx)));
            genModel.setEditorDirectory(this.toGenModelProjectPath(this.getEditorDirectory(ctx)));
            genModel.setEditPluginID(this.getEditPluginID(ctx));
            genModel.setEditorPluginID(this.getEditorPluginID(ctx));
            genModel.setValidateModel(false);
            genModel.setForceOverwrite(true);
            genModel.setCanGenerate(true);
            genModel.setFacadeHelperClass(null);
            genModel.setBundleManifest(true);
            genModel.setUpdateClasspath(false);
            genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
            genModel.setRuntimeVersion(this.emfRuntimeVerison);
            genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
        }
        genModelFile.getContents().add((Object)genModel);
        return genModel;
    }

    protected URI getGenModelUri(Grammar grammar, XpandExecutionContext ctx) {
        String prefix;
        if (this.genModel != null) {
            return URI.createURI((String)this.genModel);
        }
        try {
            prefix = String.valueOf(new File(this.getXmiModelDirectory(grammar, this.getJavaModelDirectory(ctx))).getCanonicalPath()) + File.separator + this.getModelName(grammar);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        URI genModelUri = URI.createFileURI((String)(String.valueOf(prefix) + ".genmodel"));
        return genModelUri;
    }

    protected String getJavaModelDirectory(XpandExecutionContext ctx) {
        String javaPath = this.javaModelDirectory == null || "".equals(this.javaModelDirectory) ? ctx.getOutput().getOutlet("SRC_GEN").getPath() : this.javaModelDirectory;
        return javaPath;
    }

    protected String getModelName(Grammar grammar) {
        return grammar.getName().substring(grammar.getName().lastIndexOf(46) + 1);
    }

    public String getModelPluginID(XpandExecutionContext ctx) {
        if ((this.modelPluginID == null || "".equals(this.modelPluginID)) && ctx.getVariable(MODEL_PLUGIN_ID) != null) {
            this.modelPluginID = (String)ctx.getVariable(MODEL_PLUGIN_ID).getValue();
        }
        return this.modelPluginID;
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.getBasePackage(grammar));
    }

    @Deprecated
    public String getReferencedGenModels() {
        return this.referencedGenModels;
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        return new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"};
    }

    protected GenModel getSaveAndReconcileGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs) throws ConfigurationException {
        GenModel genModel = this.getGenModel(rs, grammar, ctx, packs);
        genModel.initialize(packs);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            genPackage.setBasePackage(this.getBasePackage(grammar));
            if (this.getFileExtensions() == null || !packs.contains(genPackage.getEcorePackage())) continue;
            genPackage.setFileExtensions(this.getFileExtensions());
        }
        Set<EPackage> referencedEPackages = this.getReferencedEPackages(packs);
        List<GenPackage> usedGenPackages = this.getGenPackagesForPackages(genModel, referencedEPackages);
        this.reconcileMissingGenPackagesInUsedModels(usedGenPackages);
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        try {
            this.saveResource(genModel.eResource());
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        new GenModelHelper().registerGenModel(genModel);
        return genModel;
    }

    private void reconcileMissingGenPackagesInUsedModels(List<GenPackage> usedGenPackages) {
        HashSet processedModels = Sets.newHashSet();
        for (GenPackage usedGenPackage : usedGenPackages) {
            GenModel genModel = usedGenPackage.getGenModel();
            if (!processedModels.add(genModel)) continue;
            List missingPackages = genModel.getMissingPackages();
            List<GenPackage> missingGenPackages = this.getGenPackagesForPackages(genModel, missingPackages);
            genModel.getUsedGenPackages().addAll(missingGenPackages);
        }
    }

    public String getXmiModelDirectory() {
        return this.xmiModelDirectory;
    }

    protected String getXmiModelDirectory(Grammar grammar, String javaPath) {
        String xmiPath = this.getXmiModelDirectory() == null || "".equals(this.getXmiModelDirectory()) ? String.valueOf(javaPath) + "/" + grammar.getName().substring(0, grammar.getName().lastIndexOf(46)).replace('.', '/') : this.getXmiModelDirectory();
        return xmiPath;
    }

    public boolean isGenerateEdit() {
        return this.generateEdit;
    }

    public boolean isGenerateEditor() {
        return this.generateEditor;
    }

    public boolean isSkipGenerate() {
        return this.skipGenerate;
    }

    @Deprecated
    public void setGenModels(String uris) {
        log.warn((Object)"The property 'genModels' is deprecated. Please use 'referencedGenModels' instead.");
        this.setReferencedGenModels(uris);
    }

    public void setBasePackage(String basePackage) {
        if ("".equals(basePackage.trim())) {
            return;
        }
        this.basePackage = basePackage;
    }

    public void setEmfRuntimeVersion(String emfRuntimeVersion) {
        this.emfRuntimeVerison = GenRuntimeVersion.get((String)emfRuntimeVersion);
        if (this.emfRuntimeVerison == null) {
            log.warn((Object)("Illegal EMF runtime verison " + emfRuntimeVersion + ". Using default version instead."));
        }
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setEditorPluginID(String editorPluginId) {
        this.editorPluginID = editorPluginId;
    }

    public void setEditPluginID(String editPluginId) {
        this.editPluginID = editPluginId;
    }

    public void setGenerateEdit(boolean gen) {
        this.generateEdit = gen;
    }

    public void setGenerateEditor(boolean gen) {
        this.generateEditor = gen;
    }

    public void setGenModel(String genModel) {
        if ("".equals(genModel)) {
            return;
        }
        this.genModel = genModel;
    }

    public void setJavaModelDirectory(String dir) {
        this.javaModelDirectory = dir;
    }

    public void setModelPluginID(String modelPluginId) {
        this.modelPluginID = modelPluginId;
    }

    @Deprecated
    public void setReferencedGenModels(String referencedGenModel) {
        if ("".equals(referencedGenModel)) {
            return;
        }
        this.referencedGenModels = referencedGenModel;
        log.warn((Object)"The property 'referencedGenModels' is deprecated. Please use 'StandaloneSetup.registerGenModelFile' instead.");
    }

    @Deprecated
    protected void registerReferencedGenModels() {
        try {
            if (this.getReferencedGenModels() != null && this.getReferencedGenModels().length() > 0) {
                XtextResourceSet rs = new XtextResourceSet();
                GenModelHelper gmh = new GenModelHelper();
                String[] stringArray = this.getReferencedGenModels().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String uriStr = stringArray[n2];
                    URI uri = URI.createURI((String)uriStr.trim());
                    gmh.registerGenModel((ResourceSet)rs, uri);
                    ++n2;
                }
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public void setXmiModelDirectory(String dir) {
        this.xmiModelDirectory = dir;
    }

    protected String toGenModelProjectPath(String path) {
        return path == null || "".equals(path) || path.startsWith("/") ? path : path.substring(path.indexOf("/"));
    }

    @Deprecated
    public void addSaveMapping(Mapping mapping) {
        log.warn((Object)"Save mappings are no longer supported. The EcoreGeneratorFragment will use the uri that is given in the referenced genmodel or create a platform resource uri for new files.");
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public String getFileExtensions() {
        return this.fileExtensions;
    }

    public static class ToPlatformResourceDeresolvingURIHandler
    extends URIHandlerImpl.PlatformSchemeAware {
        public URI deresolve(URI uri) {
            return super.deresolve(EcoreGeneratorFragment.toPlatformResourceURI(uri));
        }
    }
}

