/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.copyqualifiedname;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.copyqualifiedname.ClipboardUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopyQualifiedNameHandler
extends AbstractHandler {
    @Inject
    private IResourceServiceProvider.Registry registry;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String qualifiedName = this.getQualifiedName(event);
        return ClipboardUtil.copy(qualifiedName);
    }

    protected abstract String getQualifiedName(ExecutionEvent var1);

    protected String getQualifiedName(EObject selectedElement) {
        if (selectedElement.eIsProxy()) {
            return null;
        }
        QualifiedName fullyQualifiedName = this.getFullyQualifiedName(selectedElement);
        return this.toString(selectedElement, fullyQualifiedName);
    }

    private QualifiedName getFullyQualifiedName(EObject selectedElement) {
        if (selectedElement == null) {
            return null;
        }
        return this.getQualifiedNameProvider(selectedElement).getFullyQualifiedName(selectedElement);
    }

    private String toString(EObject selectedElement, QualifiedName fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        return this.getQualifiedNameConverter(selectedElement).toString(fullyQualifiedName);
    }

    private IQualifiedNameProvider getQualifiedNameProvider(EObject selectedElement) {
        return this.getService(selectedElement, IQualifiedNameProvider.class);
    }

    private IQualifiedNameConverter getQualifiedNameConverter(EObject selectedElement) {
        return this.getService(selectedElement, IQualifiedNameConverter.class);
    }

    private <T> T getService(EObject selectedElement, Class<T> serviceClass) {
        URI uri = selectedElement.eResource().getURI();
        return (T)this.registry.getResourceServiceProvider(uri).get(serviceClass);
    }
}

