/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.resource.JvmDeclaredTypeSignatureHashProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(XbaseResourceDescriptionStrategy.class);
    public static final String SIGNATURE_HASH_KEY = "sig";
    public static final String IS_INTERFACE = "interface";
    @Inject
    private JvmDeclaredTypeSignatureHashProvider hashProvider;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, this.createLazyUserData(eObject)));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage());
        }
        return true;
    }

    protected Map<String, String> createLazyUserData(final EObject eObject) {
        return new ForwardingMap<String, String>(){
            private Map<String, String> delegate;

            protected Map<String, String> delegate() {
                if (this.delegate == null) {
                    ImmutableMap.Builder userData = ImmutableMap.builder();
                    XbaseResourceDescriptionStrategy.this.createUserData(eObject, (ImmutableMap.Builder<String, String>)userData);
                    this.delegate = userData.build();
                }
                return this.delegate;
            }
        };
    }

    protected void createUserData(EObject eObject, ImmutableMap.Builder<String, String> userData) {
        JvmGenericType genericType;
        if (eObject instanceof JvmDeclaredType) {
            userData.put((Object)SIGNATURE_HASH_KEY, (Object)this.hashProvider.getHash((JvmDeclaredType)eObject));
        }
        if (eObject instanceof JvmGenericType && (genericType = (JvmGenericType)eObject).isInterface()) {
            userData.put((Object)IS_INTERFACE, (Object)Boolean.TRUE.toString());
        }
    }

    public boolean createReferenceDescriptions(EObject from, URI exportedContainerURI, IAcceptor<IReferenceDescription> acceptor) {
        if (from instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)from).isPackageFragment()) {
            return false;
        }
        return super.createReferenceDescriptions(from, exportedContainerURI, acceptor);
    }
}

