/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLiteralHelper {
    private ExpressionTypeComputationState state;

    protected TypeLiteralHelper(ExpressionTypeComputationState state) {
        this.state = state;
    }

    @Nullable
    protected ParameterizedTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType clazzType = owner.getServices().getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        if (clazzType == null) {
            return null;
        }
        ParameterizedTypeReference result = new ParameterizedTypeReference(owner, clazzType);
        return result;
    }

    protected LightweightTypeReference getAsClassLiteral(JvmIdentifiableElement feature) {
        if (feature instanceof JvmType) {
            ParameterizedTypeReference voidType;
            ITypeReferenceOwner owner = this.state.getReferenceOwner();
            ParameterizedTypeReference result = this.getRawTypeForName(Class.class, owner);
            if (result == null) {
                return new UnknownTypeReference(owner, "Class");
            }
            LightweightTypeReference argumentType = new ParameterizedTypeReference(owner, (JvmType)feature);
            argumentType = argumentType.isPrimitiveVoid() ? ((voidType = this.getRawTypeForName(Void.class, owner)) == null ? new UnknownTypeReference(owner, Void.class.getName()) : voidType) : ((LightweightTypeReference)argumentType).getWrapperTypeIfPrimitive();
            result.addTypeArgument(argumentType);
            return result;
        }
        throw new IllegalArgumentException(String.valueOf(feature));
    }

    protected void applyPackageFragment(XAbstractFeatureCall expression, JvmType type) {
        JvmDeclaredType declaredType;
        if (expression instanceof XMemberFeatureCall && type instanceof JvmDeclaredType && (declaredType = (JvmDeclaredType)type).getDeclaringType() == null) {
            this.applyPackageFragment((XMemberFeatureCall)expression, declaredType);
        }
    }

    protected void applyPackageFragment(XMemberFeatureCall memberFeatureCall, JvmDeclaredType type) {
        XExpression target = memberFeatureCall.getMemberCallTarget();
        this.state.getResolvedTypes().acceptType(target, new NoExpectation(this.state, false), new ParameterizedTypeReference(this.state.getReferenceOwner(), (JvmType)type), false, ConformanceHint.SUCCESS, ConformanceHint.CHECKED);
        if (target instanceof XMemberFeatureCall) {
            this.applyPackageFragment((XMemberFeatureCall)target, type);
        }
    }
}

