/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.internal;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stopwatches {
    private static Map<String, NumbersForTask> data = Maps.newLinkedHashMap();
    private static boolean enabled = false;
    private static StoppedTask NULLIMPL = new StoppedTask(){

        public void start() {
        }

        public void stop() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoppedTask forTask(String task) {
        if (!enabled) {
            return NULLIMPL;
        }
        Map<String, NumbersForTask> map = data;
        synchronized (map) {
            NumbersForTask numbers = data.get(task);
            if (numbers == null) {
                numbers = new NumbersForTask();
                data.put(task, numbers);
            }
            return new StopwatchForTask(numbers);
        }
    }

    public static void setEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAll() {
        Map<String, NumbersForTask> map = data;
        synchronized (map) {
            data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, NumbersForTask> allNumbers() {
        Map<String, NumbersForTask> map = data;
        synchronized (map) {
            return Collections.unmodifiableMap(data);
        }
    }

    public static String getPrintableStopwatchData() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        for (Map.Entry<String, NumbersForTask> task : Stopwatches.allNumbers().entrySet()) {
            sb.append("Task '" + task.getKey() + "' took " + task.getValue().getMilliseconds() + "ms (" + task.getValue().getNumberOfMeasurements() + " measurements).\n");
        }
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public static class NumbersForTask {
        long milliseconds = 0L;
        int numberOfMeasurements = 0;

        public long getMilliseconds() {
            return this.milliseconds;
        }

        synchronized void addMilliseconds(long milliseconds) {
            this.milliseconds += milliseconds;
        }

        public int getNumberOfMeasurements() {
            return this.numberOfMeasurements;
        }

        synchronized void increaseMeasurements() {
            ++this.numberOfMeasurements;
        }
    }

    public static interface StoppedTask {
        public void start();

        public void stop();
    }

    public static class StopwatchForTask
    implements StoppedTask {
        static final long notRunning = -1L;
        private NumbersForTask numbers;
        private long lastStart = -1L;
        private int reentrant = 0;

        StopwatchForTask(NumbersForTask numbers) {
            this.numbers = numbers;
        }

        public void start() {
            if (!this.isRunning()) {
                this.lastStart = System.currentTimeMillis();
            }
            ++this.reentrant;
        }

        public boolean isRunning() {
            return this.lastStart != -1L;
        }

        public void stop() {
            if (this.isRunning()) {
                --this.reentrant;
                if (this.reentrant == 0) {
                    long currentTimeMillis = System.currentTimeMillis();
                    this.numbers.addMilliseconds(currentTimeMillis - this.lastStart);
                    this.numbers.increaseMeasurements();
                    this.lastStart = -1L;
                }
            }
        }
    }
}

