/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.override.RawResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ParameterizedResolvedFeatures
implements IResolvedFeatures {
    private LightweightTypeReference type;
    private RawResolvedFeatures parent;

    public ParameterizedResolvedFeatures(LightweightTypeReference type, RawResolvedFeatures parent) {
        this.type = type;
        this.parent = parent;
    }

    @Override
    public List<JvmFeature> getAllFeatures(String simpleName) {
        List<JvmFeature> result = this.parent.getAllFeatures(simpleName);
        if (this.type.getTypeArguments().isEmpty() || result.size() <= 1) {
            return result;
        }
        return this.computeAllFeatures(result);
    }

    @Override
    public IResolvedFeatures getParameterizedView(LightweightTypeReference concrete) {
        return this.parent.getParameterizedView(concrete);
    }

    protected List<JvmFeature> computeAllFeatures(List<JvmFeature> unfiltered) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)unfiltered.size());
        HashMultimap processed = HashMultimap.create();
        this.computeAllFeatures(unfiltered, (Multimap<String, AbstractResolvedOperation>)processed, result);
        return Collections.unmodifiableList(result);
    }

    protected void computeAllFeatures(List<JvmFeature> unfiltered, Multimap<String, AbstractResolvedOperation> processedOperations, List<JvmFeature> result) {
        for (JvmFeature feature : unfiltered) {
            if (feature instanceof JvmOperation) {
                String simpleName = feature.getSimpleName();
                if (processedOperations.containsKey((Object)simpleName) && this.parent.isOverridden((JvmOperation)feature, processedOperations.get((Object)simpleName))) continue;
                BottomResolvedOperation resolvedOperation = this.parent.createResolvedOperation((JvmOperation)feature, this.type);
                processedOperations.put((Object)simpleName, (Object)resolvedOperation);
                result.add(feature);
                continue;
            }
            result.add(feature);
        }
    }
}

