/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractTypeReferencePairWalker
extends TypeReferenceVisitorWithParameter<LightweightTypeReference> {
    private final ITypeReferenceOwner owner;
    private final ParameterizedTypeReferenceTraverser parameterizedTypeReferenceTraverser;
    private final WildcardTypeReferenceTraverser wildcardTypeReferenceTraverser;
    private final ArrayTypeReferenceTraverser arrayTypeReferenceTraverser;
    private final CompoundTypeReferenceTraverser compoundTypeReferenceTraverser;
    private final UnboundTypeReferenceTraverser unboundTypeReferenceTraverser;
    private VarianceInfo expectedVariance;
    private VarianceInfo actualVariance;
    private Object origin;
    private final Set<String> recursionGuard;

    protected AbstractTypeReferencePairWalker(ITypeReferenceOwner owner) {
        this.owner = owner;
        this.recursionGuard = Sets.newHashSetWithExpectedSize((int)3);
        this.parameterizedTypeReferenceTraverser = this.createParameterizedTypeReferenceTraverser();
        this.wildcardTypeReferenceTraverser = this.createWildcardTypeReferenceTraverser();
        this.arrayTypeReferenceTraverser = this.createArrayTypeReferenceTraverser();
        this.compoundTypeReferenceTraverser = this.createCompoundTypeReferenceTraverser();
        this.unboundTypeReferenceTraverser = this.createUnboundTypeReferenceTraverser();
    }

    protected void processTypeParameter(JvmTypeParameter typeParameter, LightweightTypeReference reference) {
    }

    protected boolean shouldProcess(JvmTypeParameter typeParameter) {
        return true;
    }

    protected UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
        return new UnboundTypeReferenceTraverser();
    }

    protected ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
        return new ArrayTypeReferenceTraverser();
    }

    protected CompoundTypeReferenceTraverser createCompoundTypeReferenceTraverser() {
        return new CompoundTypeReferenceTraverser();
    }

    protected WildcardTypeReferenceTraverser createWildcardTypeReferenceTraverser() {
        return new WildcardTypeReferenceTraverser();
    }

    protected ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new ParameterizedTypeReferenceTraverser();
    }

    @Override
    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTypeReference param) {
        param.accept(this.parameterizedTypeReferenceTraverser, reference);
    }

    @Override
    protected void doVisitWildcardTypeReference(WildcardTypeReference declaredReference, LightweightTypeReference param) {
        param.accept(this.wildcardTypeReferenceTraverser, declaredReference);
    }

    @Override
    protected void doVisitArrayTypeReference(ArrayTypeReference declaredReference, LightweightTypeReference param) {
        param.accept(this.arrayTypeReferenceTraverser, declaredReference);
    }

    @Override
    protected void doVisitCompoundTypeReference(CompoundTypeReference declaredReference, LightweightTypeReference param) {
        param.accept(this.compoundTypeReferenceTraverser, declaredReference);
    }

    @Override
    protected void doVisitUnboundTypeReference(UnboundTypeReference reference, LightweightTypeReference param) {
        param.accept(this.unboundTypeReferenceTraverser, reference);
    }

    @Override
    protected void doVisitAnyTypeReference(AnyTypeReference reference, LightweightTypeReference param) {
    }

    @Override
    protected void doVisitUnknownTypeReference(UnknownTypeReference reference, LightweightTypeReference param) {
    }

    protected void outerVisit(LightweightTypeReference declaredType, LightweightTypeReference actualType, Object origin, VarianceInfo expectedVariance, VarianceInfo actualVariance) {
        VarianceInfo oldExpectedVariance = this.expectedVariance;
        VarianceInfo oldActualVariance = this.actualVariance;
        Object oldOrigin = this.origin;
        try {
            this.expectedVariance = expectedVariance;
            this.actualVariance = actualVariance;
            this.origin = origin;
            this.outerVisit(declaredType, actualType);
        }
        finally {
            this.expectedVariance = oldExpectedVariance;
            this.actualVariance = oldActualVariance;
            this.origin = oldOrigin;
        }
    }

    protected void outerVisit(LightweightTypeReference declaredType, LightweightTypeReference actualType) {
        String key;
        String actualKey;
        if (declaredType == actualType) {
            return;
        }
        String declaredKey = declaredType.getUniqueIdentifier();
        if (!declaredKey.equals(actualKey = actualType.getUniqueIdentifier()) && this.recursionGuard.add(key = String.valueOf(declaredKey) + "//" + actualKey)) {
            try {
                declaredType.accept(this, actualType);
            }
            finally {
                this.recursionGuard.remove(key);
            }
        }
    }

    public void processPairedReferences(LightweightTypeReference declaredType, LightweightTypeReference actualType) {
        this.outerVisit(declaredType, actualType, declaredType, VarianceInfo.OUT, VarianceInfo.OUT);
    }

    protected VarianceInfo getActualVariance() {
        return this.actualVariance;
    }

    protected VarianceInfo getExpectedVariance() {
        return this.expectedVariance;
    }

    protected Object getOrigin() {
        return this.origin;
    }

    protected ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new StandardTypeParameterSubstitutor(mapping, this.owner);
    }

    @Nullable
    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping, Collection<JvmTypeParameter> visited) {
        for (Map.Entry<JvmTypeParameter, LightweightMergedBoundTypeArgument> entry : mapping.entrySet()) {
            LightweightMergedBoundTypeArgument reference = entry.getValue();
            JvmType type = reference.getTypeReference().getType();
            if (parameter != type) continue;
            if (visited.add(entry.getKey())) {
                return entry.getKey();
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayTypeReferenceTraverser
    extends TypeReferenceVisitorWithParameter<ArrayTypeReference> {
        protected ArrayTypeReferenceTraverser() {
        }

        @Override
        protected void doVisitArrayTypeReference(ArrayTypeReference reference, ArrayTypeReference declaration) {
            AbstractTypeReferencePairWalker.this.outerVisit(declaration.getComponentType(), reference.getComponentType());
        }

        @Override
        protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ArrayTypeReference declaration) {
            JvmType type = reference.getType();
            if (type instanceof JvmTypeParameter) {
                if (AbstractTypeReferencePairWalker.this.shouldProcess((JvmTypeParameter)type)) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                    AbstractTypeReferencePairWalker.this.processTypeParameter(typeParameter, declaration);
                }
            } else {
                LightweightTypeReference declarationAsList = declaration.tryConvertToListType();
                AbstractTypeReferencePairWalker.this.outerVisit(declarationAsList, reference);
            }
        }

        @Override
        protected void doVisitAnyTypeReference(AnyTypeReference reference, ArrayTypeReference param) {
        }

        @Override
        protected void doVisitUnknownTypeReference(UnknownTypeReference reference, ArrayTypeReference param) {
        }

        @Override
        protected void doVisitUnboundTypeReference(UnboundTypeReference reference, ArrayTypeReference declaration) {
            if (AbstractTypeReferencePairWalker.this.shouldProcess(reference.getTypeParameter())) {
                AbstractTypeReferencePairWalker.this.processTypeParameter(reference.getTypeParameter(), declaration);
            }
        }

        @Override
        protected void doVisitWildcardTypeReference(WildcardTypeReference reference, ArrayTypeReference declaration) {
            LightweightTypeReference lowerBound = reference.getLowerBound();
            if (lowerBound != null) {
                AbstractTypeReferencePairWalker.this.outerVisit(declaration, lowerBound, declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.IN);
            } else {
                for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaration, upperBound, declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.OUT);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompoundTypeReferenceTraverser
    extends TypeReferenceVisitorWithParameter<CompoundTypeReference> {
        protected CompoundTypeReferenceTraverser() {
        }

        @Override
        protected void doVisitTypeReference(LightweightTypeReference reference, CompoundTypeReference declaration) {
            List<LightweightTypeReference> components = declaration.getMultiTypeComponents();
            if (!components.isEmpty()) {
                for (LightweightTypeReference component : components) {
                    AbstractTypeReferencePairWalker.this.outerVisit(component, reference);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParameterizedTypeReferenceTraverser
    extends TypeReferenceVisitorWithParameter<ParameterizedTypeReference> {
        protected ParameterizedTypeReferenceTraverser() {
        }

        @Override
        protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter) {
                if (type != reference.getType() && AbstractTypeReferencePairWalker.this.shouldProcess((JvmTypeParameter)type)) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                    AbstractTypeReferencePairWalker.this.processTypeParameter(typeParameter, reference);
                }
            } else if (type instanceof JvmTypeParameterDeclarator && !((JvmTypeParameterDeclarator)type).getTypeParameters().isEmpty() && !declaration.getTypeArguments().isEmpty()) {
                this.doVisitMatchingTypeParameters(reference, declaration);
            }
        }

        @Override
        protected void doVisitAnyTypeReference(AnyTypeReference reference, ParameterizedTypeReference param) {
        }

        @Override
        protected void doVisitUnknownTypeReference(UnknownTypeReference reference, ParameterizedTypeReference param) {
        }

        protected void doVisitMatchingTypeParameters(ParameterizedTypeReference reference, ParameterizedTypeReference declaration) {
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> actualMapping = this.getTypeParameterMapping(reference);
            TypeParameterSubstitutor<?> actualSubstitutor = AbstractTypeReferencePairWalker.this.createTypeParameterSubstitutor(actualMapping);
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> declaredMapping = this.getTypeParameterMapping(declaration);
            TypeParameterSubstitutor<?> declaredSubstitutor = AbstractTypeReferencePairWalker.this.createTypeParameterSubstitutor(declaredMapping);
            Set<JvmTypeParameter> actualBoundParameters = actualMapping.keySet();
            HashSet visited = Sets.newHashSet();
            block0: for (JvmTypeParameter actualBoundParameter : actualBoundParameters) {
                LightweightTypeReference actual;
                if (!visited.add(actualBoundParameter)) continue;
                LightweightMergedBoundTypeArgument declaredBoundArgument = declaredMapping.get(actualBoundParameter);
                while (declaredBoundArgument == null && actualBoundParameter != null) {
                    if ((actualBoundParameter = AbstractTypeReferencePairWalker.this.findMappedParameter(actualBoundParameter, actualMapping, visited)) == null) continue block0;
                    declaredBoundArgument = declaredMapping.get(actualBoundParameter);
                }
                if (declaredBoundArgument == null) continue;
                LightweightTypeReference declaredTypeReference = declaredBoundArgument.getTypeReference();
                JvmType declaredType = declaredTypeReference.getType();
                if (declaredType instanceof JvmTypeParameter) {
                    JvmTypeParameter declaredTypeParameter = (JvmTypeParameter)declaredType;
                    if (!this.shouldProcessInContextOf(declaredTypeParameter, actualBoundParameters, visited)) continue;
                    declaredTypeReference = declaredSubstitutor.substitute(declaredTypeReference);
                }
                if ((actual = actualSubstitutor.substitute(actualMapping.get(actualBoundParameter).getTypeReference())).isResolved() && declaredTypeReference.isResolved() && Strings.equal((String)actual.getIdentifier(), (String)declaredTypeReference.getIdentifier()) || reference.getType() == actual.getType() && declaredTypeReference.getType() == declaration.getType() && reference.getIdentifier().equals(actual.getIdentifier()) && declaredTypeReference.getIdentifier().equals(declaration.getIdentifier())) continue;
                AbstractTypeReferencePairWalker.this.outerVisit(declaredTypeReference, actual, declaration, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
        }

        public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping(ParameterizedTypeReference reference) {
            DeclaratorTypeArgumentCollector collector = new DeclaratorTypeArgumentCollector();
            return collector.getTypeParameterMapping(reference);
        }

        protected boolean shouldProcessInContextOf(JvmTypeParameter typeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
            return true;
        }

        @Override
        protected void doVisitArrayTypeReference(ArrayTypeReference reference, ParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter && AbstractTypeReferencePairWalker.this.shouldProcess((JvmTypeParameter)type)) {
                JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                AbstractTypeReferencePairWalker.this.processTypeParameter(typeParameter, reference);
            }
        }

        @Override
        protected void doVisitWildcardTypeReference(WildcardTypeReference reference, ParameterizedTypeReference declaration) {
            LightweightTypeReference lowerBound = reference.getLowerBound();
            if (lowerBound != null) {
                AbstractTypeReferencePairWalker.this.outerVisit(declaration, lowerBound, declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.IN);
            } else {
                for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaration, upperBound, declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.OUT);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnboundTypeReferenceTraverser
    extends TypeReferenceVisitorWithParameter<UnboundTypeReference> {
        protected UnboundTypeReferenceTraverser() {
        }

        @Override
        protected void doVisitTypeReference(LightweightTypeReference reference, UnboundTypeReference declaration) {
            if (declaration.internalIsResolved() || AbstractTypeReferencePairWalker.this.getOwner().isResolved(declaration.getHandle())) {
                declaration.tryResolve();
                AbstractTypeReferencePairWalker.this.outerVisit(declaration, reference, declaration, AbstractTypeReferencePairWalker.this.getExpectedVariance(), AbstractTypeReferencePairWalker.this.getActualVariance());
            } else {
                AbstractTypeReferencePairWalker.this.processTypeParameter(declaration.getTypeParameter(), reference);
            }
        }

        @Override
        protected void doVisitWildcardTypeReference(WildcardTypeReference reference, UnboundTypeReference declaration) {
            LightweightTypeReference lowerBound = reference.getLowerBound();
            if (lowerBound != null) {
                AbstractTypeReferencePairWalker.this.outerVisit(declaration, lowerBound, declaration, AbstractTypeReferencePairWalker.this.getExpectedVariance(), VarianceInfo.IN);
            } else {
                for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaration, upperBound, declaration, AbstractTypeReferencePairWalker.this.getExpectedVariance(), VarianceInfo.OUT);
                }
            }
        }

        @Override
        protected void doVisitUnboundTypeReference(UnboundTypeReference reference, UnboundTypeReference param) {
            if (param.equalHandles(reference)) {
                return;
            }
            super.doVisitUnboundTypeReference(reference, param);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WildcardTypeReferenceTraverser
    extends TypeReferenceVisitorWithParameter<WildcardTypeReference> {
        protected WildcardTypeReferenceTraverser() {
        }

        @Override
        protected void doVisitWildcardTypeReference(WildcardTypeReference reference, WildcardTypeReference declaration) {
            LightweightTypeReference declaredLowerBound = declaration.getLowerBound();
            if (declaredLowerBound != null) {
                LightweightTypeReference actualLowerBound = reference.getLowerBound();
                if (actualLowerBound != null) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredLowerBound, actualLowerBound, declaration, VarianceInfo.IN, VarianceInfo.IN);
                } else {
                    for (LightweightTypeReference actualUpperBound : reference.getUpperBounds()) {
                        AbstractTypeReferencePairWalker.this.outerVisit(declaredLowerBound, actualUpperBound, declaration, VarianceInfo.IN, VarianceInfo.OUT);
                    }
                }
            } else {
                LightweightTypeReference actualLowerBound = reference.getLowerBound();
                for (LightweightTypeReference declaredUpperBound : declaration.getUpperBounds()) {
                    for (LightweightTypeReference actualUpperBound : reference.getUpperBounds()) {
                        AbstractTypeReferencePairWalker.this.outerVisit(declaredUpperBound, actualUpperBound, declaration, VarianceInfo.OUT, VarianceInfo.OUT);
                    }
                    if (actualLowerBound == null) continue;
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredUpperBound, actualLowerBound, declaration, VarianceInfo.OUT, VarianceInfo.IN);
                }
            }
        }

        @Override
        protected void doVisitCompoundTypeReference(CompoundTypeReference reference, WildcardTypeReference param) {
            if (!reference.isSynonym()) {
                this.doVisitTypeReference((LightweightTypeReference)reference, param);
            } else {
                super.doVisitCompoundTypeReference(reference, param);
            }
        }

        @Override
        public void doVisitTypeReference(LightweightTypeReference reference, WildcardTypeReference declaration) {
            LightweightTypeReference declaredLowerBound = declaration.getLowerBound();
            if (declaredLowerBound != null) {
                AbstractTypeReferencePairWalker.this.outerVisit(declaredLowerBound, reference, declaration, VarianceInfo.IN, VarianceInfo.INVARIANT);
            } else {
                for (LightweightTypeReference declaredUpperBound : declaration.getUpperBounds()) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredUpperBound, reference, declaration, VarianceInfo.OUT, VarianceInfo.INVARIANT);
                }
            }
        }
    }
}

