/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.Test;

public class InternalBuilderTest {
    @Test
    public void test() throws CoreException, FileNotFoundException {
        System.out.println("JDT Version:" + JavaCore.getPlugin().getBundle().getVersion());
        System.out.println("JDT UI Version:" + JavaPlugin.getDefault().getBundle().getVersion());
        this.reportMemoryState("Starting build.");
        try {
            this.dumpMemoryIndex("Initial Memory Index state");
            this.dumpDiskIndex();
            this.clearJdtIndex();
            this.dumpMemoryIndex("Memory Index state after clear disk");
            this.dumpDiskIndex();
            JavaModelManager.getIndexManager().resetIndex((IPath)new Path("/org.eclipse.xtext"));
            this.dumpMemoryIndex("Memory Index state after reset project");
            this.dumpDiskIndex();
            System.out.println("Saving index.");
            JavaModelManager.getIndexManager().saveIndexes();
            this.dumpMemoryIndex("Memory Index state after save");
            this.dumpDiskIndex();
            InternalBuilderTest.setAutoBuild(true);
            InternalBuilderTest.waitForAutoBuild();
        }
        finally {
            InternalBuilderTest.setAutoBuild(false);
            System.out.println("Stopping background indexing.");
            JavaModelManager.getIndexManager().shutdown();
            this.clearJdtIndex();
            this.reportMemoryState("Finished build.");
        }
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ArrayList<String> errors = new ArrayList<String>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String msg = MarkerUtilities.getMessage((IMarker)marker);
            if (MarkerUtilities.getSeverity((IMarker)marker) == 2) {
                errors.add(String.valueOf(msg) + " in " + marker.getResource().getFullPath() + " line: " + MarkerUtilities.getLineNumber((IMarker)marker));
            }
            ++n2;
        }
        List<String> top10 = errors.size() > 10 ? IterableExtensions.toList((Iterable)IterableExtensions.take(errors, (int)10)) : errors;
        Assert.assertTrue((String)("Problems found (" + top10.size() + " of " + errors.size() + "): " + IterableExtensions.join(errors, (CharSequence)", ")), (boolean)errors.isEmpty());
    }

    private void dumpMemoryIndex(String message) {
        System.out.println(String.valueOf(message) + ":\n" + JavaModelManager.getIndexManager().toString());
    }

    private void dumpDiskIndex() {
        File jdtMetadata = JavaCore.getPlugin().getStateLocation().toFile();
        System.out.println("Disk index " + Strings.concatenate((String[])jdtMetadata.list(), (String)","));
    }

    private void clearJdtIndex() throws FileNotFoundException {
        JavaModelManager.getIndexManager().deleteIndexFiles();
        System.out.println("Cleaned up jdt's disk index.");
    }

    private void reportMemoryState(String reportName) {
        System.out.println(String.valueOf(reportName) + " Memory max=" + Runtime.getRuntime().maxMemory() / 0x100000L + "m, total=" + Runtime.getRuntime().totalMemory() / 0x100000L + "m, free=" + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
    }

    public static void cleanBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)new NullProgressMonitor());
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void fullBuild() throws CoreException {
        System.out.println("Starting full build");
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void waitForAutoBuild() {
        System.out.println("Waiting for auto-build");
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void setAutoBuild(boolean b) {
        System.out.println("Setting auto-build to " + b);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IWorkspaceDescription desc = workspace.getDescription();
            desc.setAutoBuilding(b);
            workspace.setDescription(desc);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

