/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineFilterAndSorter;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeContentProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeElementOpener;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeLabelProvider;
import org.eclipse.xtext.ui.editor.outline.quickoutline.Messages;
import org.eclipse.xtext.ui.editor.outline.quickoutline.PrefixMatcherOutlineAdapter;
import org.eclipse.xtext.ui.editor.outline.quickoutline.QuickOutlineFilterAndSorter;
import org.eclipse.xtext.ui.editor.outline.quickoutline.StringMatcher;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class QuickOutlinePopup
extends PopupDialog
implements DisposeListener {
    @Inject
    private IOutlineTreeProvider treeProvider;
    @Inject
    private OutlineNodeLabelProvider labelProvider;
    @Inject
    private OutlineNodeContentProvider contentProvider;
    @Inject
    private OutlineFilterAndSorter.IComparator comparator;
    @Inject
    private QuickOutlineFilterAndSorter filterAndSorter;
    @Inject
    private PrefixMatcher prefixMatcher;
    @Inject
    private OutlineNodeElementOpener elementOpener;
    private int TREESTYLE = 768;
    private TreeViewer treeViewer;
    private IXtextDocument document;
    private XtextEditor xtextEditor;
    private Text filterText;
    private PrefixMatcherOutlineAdapter prefixMatcherOutlineAdapter;
    private KeyStroke invokingKeystroke;

    public QuickOutlinePopup() {
        this(null);
    }

    public QuickOutlinePopup(Shell parent) {
        super(parent, 16, true, false, true, true, true, null, Messages.QuickOutlinePopup_pressESC);
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = this.createFilterText(parent);
        return this.filterText;
    }

    protected Control createDialogArea(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent, this.TREESTYLE);
        Tree tree = this.treeViewer.getTree();
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickOutlinePopup.this.dispose();
                } else if (e.keyCode == QuickOutlinePopup.this.invokingKeystroke.getNaturalKey() && e.stateMask == QuickOutlinePopup.this.invokingKeystroke.getModifierKeys()) {
                    QuickOutlinePopup.this.changeOutlineMode();
                    e.doit = false;
                }
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlinePopup.this.gotoSelectedElement();
            }
        });
        this.installFilter();
        this.setInfoText();
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected void setInfoText() {
        if (this.treeProvider instanceof IOutlineTreeProvider.ModeAware) {
            this.setInfoText("Press " + this.invokingKeystroke + " to " + ((IOutlineTreeProvider.ModeAware)((Object)this.treeProvider)).getNextMode().getDescription());
        } else {
            this.setInfoText(Messages.QuickOutlinePopup_pressESC);
        }
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.addFilter((ViewerFilter)new NamePatternFilter());
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.filterAndSorter.setComparator(this.comparator);
        this.contentProvider.setFilterAndSorter(this.filterAndSorter);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        treeViewer.setAutoExpandLevel(-1);
        IOutlineNode rootNode = (IOutlineNode)this.document.readOnly((IUnitOfWork)new IUnitOfWork<IOutlineNode, XtextResource>(){

            public IOutlineNode exec(XtextResource state) throws Exception {
                IOutlineNode rootNode = QuickOutlinePopup.this.treeProvider.createRoot(QuickOutlinePopup.this.document);
                this.createChildrenRecursively(rootNode.getChildren());
                return rootNode;
            }

            protected void createChildrenRecursively(List<IOutlineNode> nodes) {
                for (IOutlineNode node : nodes) {
                    this.createChildrenRecursively(node.getChildren());
                }
            }
        });
        treeViewer.setInput((Object)rootNode);
        return treeViewer;
    }

    protected Text createFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.filterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickOutlinePopup.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    QuickOutlinePopup.this.treeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    QuickOutlinePopup.this.treeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    QuickOutlinePopup.this.dispose();
                }
                if (e.keyCode == QuickOutlinePopup.this.invokingKeystroke.getNaturalKey() && e.stateMask == QuickOutlinePopup.this.invokingKeystroke.getModifierKeys()) {
                    QuickOutlinePopup.this.changeOutlineMode();
                    e.doit = false;
                }
            }
        });
        return this.filterText;
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    protected void installFilter() {
        this.filterText.setText("");
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                QuickOutlinePopup.this.setMatcherString(text, true);
            }
        });
    }

    protected StringMatcher getMatcher() {
        return this.prefixMatcherOutlineAdapter;
    }

    protected boolean hasMatcher() {
        return this.prefixMatcherOutlineAdapter != null;
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.prefixMatcherOutlineAdapter = pattern.length() == 0 ? null : new PrefixMatcherOutlineAdapter(pattern, this.prefixMatcher);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected void stringMatcherUpdated() {
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        this.selectFirstMatch();
        this.treeViewer.getControl().setRedraw(true);
    }

    protected void selectFirstMatch() {
        Object[] rootElements = this.contentProvider.getElements(this.treeViewer.getInput());
        Object matchingElement = this.findMatchingElement(rootElements);
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (matchingElement != null) {
            selection = new StructuredSelection(matchingElement);
        }
        this.treeViewer.setSelection((ISelection)selection);
    }

    protected Object findMatchingElement(Object[] elements) {
        if (this.hasMatcher()) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String text = this.labelProvider.getStyledStringProvider().getStyledText(element).getString();
                if (this.getMatcher().match(text)) {
                    return element;
                }
                Object[] children = this.contentProvider.getChildren(element);
                Object matchingChild = this.findMatchingElement(children);
                if (matchingChild != null) {
                    return matchingChild;
                }
                ++n2;
            }
        }
        return null;
    }

    protected Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.dispose();
            if (selectedElement instanceof IOutlineNode) {
                this.elementOpener.open((IOutlineNode)selectedElement, this.xtextEditor.getInternalSourceViewer());
            }
        }
    }

    public final void dispose() {
        this.close();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void widgetDisposed(DisposeEvent event) {
        this.treeViewer = null;
        this.filterText = null;
    }

    public void setInput(IXtextDocument document) {
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.treeProvider.createRoot(document));
        }
        this.document = document;
    }

    protected Point getDefaultLocation(Point initialSize) {
        Control textWidget = (Control)this.xtextEditor.getAdapter(Control.class);
        Point size = textWidget.getSize();
        Point popupLocation = new Point(size.x / 2 - initialSize.x / 2, size.y / 2 - initialSize.y / 2);
        return textWidget.toDisplay(popupLocation);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = "xtext.quickoutline";
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public void setEditor(XtextEditor xtextEditor) {
        this.xtextEditor = xtextEditor;
    }

    public void setEvent(Event event) {
        this.invokingKeystroke = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
    }

    protected void changeOutlineMode() {
        if (this.treeProvider instanceof IOutlineTreeProvider.ModeAware) {
            IOutlineTreeProvider.ModeAware modeTreeProvider = (IOutlineTreeProvider.ModeAware)((Object)this.treeProvider);
            OutlineMode nextMode = modeTreeProvider.getNextMode();
            modeTreeProvider.setCurrentMode(nextMode);
            this.setInfoText();
            this.setInput(this.document);
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = QuickOutlinePopup.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if ((matchName = TextProcessor.deprocess((String)matchName)) != null && matcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        protected boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (this.select((Viewer)viewer, element, children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

