/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedExecutableScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.ExtensionScopeHelper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescription;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicExtensionsScope
extends AbstractSessionBasedExecutableScope {
    private final ExtensionScopeHelper helper;
    private final XExpression firstArgument;
    private final LightweightTypeReference argumentType;
    private final boolean implicit;
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> argumentTypeParameterMapping;

    public DynamicExtensionsScope(IScope parent, IFeatureScopeSession session, XExpression firstArgument, LightweightTypeReference argumentType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
        this.firstArgument = firstArgument;
        this.argumentType = argumentType;
        this.implicit = implicit;
        this.helper = argumentType != null ? new ExtensionScopeHelper(argumentType) : null;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getArgumentTypeParameterMapping() {
        if (this.argumentTypeParameterMapping == null) {
            this.argumentTypeParameterMapping = Collections.emptyMap();
            if (this.argumentType != null) {
                this.argumentTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.argumentType);
            }
        }
        return this.argumentTypeParameterMapping;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (ExpressionBucket bucket : buckets) {
            Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
            for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
                LinkedHashSet allFeatures = Sets.newLinkedHashSet();
                LightweightTypeReference extensionType = extensionProvider.getValue();
                List<JvmType> types = extensionType.getRawTypes();
                for (JvmType type : types) {
                    if (!(type instanceof JvmDeclaredType)) continue;
                    IResolvedFeatures resolvedFeatures = bucket.getResolvedFeaturesProvider().getResolvedFeatures(type).getParameterizedView(extensionType);
                    List<JvmFeature> features = resolvedFeatures.getAllFeatures();
                    Iterables.addAll((Collection)allFeatures, features);
                }
                if (allFeatures.isEmpty()) continue;
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
                for (JvmFeature feature : allFeatures) {
                    if (feature.isStatic()) continue;
                    this.addDescriptions(feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket, result);
                }
            }
        }
        return result;
    }

    protected void addDescriptions(JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, List<IEObjectDescription> result) {
        QualifiedName operator;
        String propertyName;
        BucketedEObjectDescription description;
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create((String)simpleName);
        if (this.firstArgument != null && this.helper.isPossibleExtension(feature) && this.helper.isMatchingFirstParameter((JvmOperation)feature) && (description = this.doCreateExtensionDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket)) != null) {
            result.add(description);
            propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                result.add(this.doCreateExtensionDescription(QualifiedName.create((String)propertyName), feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
        }
        if (this.implicit && (description = this.createReceiverDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket)) != null) {
            result.add(description);
            propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                result.add(this.createReceiverDescription(QualifiedName.create((String)propertyName), feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
        }
        if ((operator = this.getOperatorMapping().getOperator(featureName)) != null) {
            if (this.firstArgument != null) {
                result.add(this.doCreateExtensionDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
            if (this.implicit) {
                result.add(this.createReceiverDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
        }
    }

    protected List<ExpressionBucket> getBuckets() {
        return this.getSession().getExtensionProviders();
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (final ExpressionBucket bucket : buckets) {
            Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
            for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
                final LightweightTypeReference extensionType = extensionProvider.getValue();
                if (extensionType == null) {
                    throw new IllegalStateException("extensionType is null");
                }
                final List<JvmType> types = extensionType.getRawTypes();
                final LinkedHashSet allFeatures = Sets.newLinkedHashSet();
                this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

                    public void accept(String simpleName, int order) {
                        for (JvmType type : types) {
                            if (!(type instanceof JvmDeclaredType)) continue;
                            IResolvedFeatures resolvedFeatures = bucket.getResolvedFeaturesProvider().getResolvedFeatures(type).getParameterizedView(extensionType);
                            List<JvmFeature> features = resolvedFeatures.getAllFeatures(simpleName);
                            List<JvmFeature> filtered = order == 1 ? features : Iterables.filter(features, JvmOperation.class);
                            Iterables.addAll((Collection)allFeatures, filtered);
                        }
                    }
                });
                if (allFeatures.isEmpty()) continue;
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
                for (JvmFeature feature : allFeatures) {
                    BucketedEObjectDescription description;
                    if (feature.isStatic()) continue;
                    if (this.firstArgument != null && (description = this.createExtensionDescription(name, feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket)) != null) {
                        result.add(description);
                    }
                    if (!this.implicit) continue;
                    result.add(this.createReceiverDescription(name, feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket));
                }
            }
        }
        return result;
    }

    protected BucketedEObjectDescription createExtensionDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket) {
        if (this.helper == null || !this.helper.isPossibleExtension(feature)) {
            return null;
        }
        return this.doCreateExtensionDescription(name, feature, receiver, receiverType, receiverTypeParameterMapping, bucket);
    }

    protected BucketedEObjectDescription doCreateExtensionDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket) {
        if (this.implicit) {
            return new InstanceExtensionDescriptionWithImplicitFirstArgument(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new InstanceExtensionDescription(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), EnumSet.of(ConformanceHint.UNCHECKED), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    protected BucketedEObjectDescription createReceiverDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket) {
        return new InstanceFeatureDescriptionWithImplicitReceiver(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    @Override
    protected String toProperty(String methodName, JvmFeature feature) {
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (methodName.length() > 3 && (methodName.startsWith("get") && operation.getParameters().size() == 1 || methodName.startsWith("set") && operation.getParameters().size() == 2) && Character.isUpperCase(methodName.charAt(3))) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (methodName.length() > 3 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2)) && operation.getParameters().size() == 1) {
                return Introspector.decapitalize(methodName.substring(2));
            }
        }
        return null;
    }
}

