/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class NewFeatureNameUtil {
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    private Set<String> allKeywords;
    private IScope featureCallScope;

    @Inject
    public NewFeatureNameUtil(IGrammarAccess grammarAccess) {
        this.allKeywords = GrammarUtil.getAllKeywords((Grammar)grammarAccess.getGrammar());
    }

    public void setFeatureScopeContext(XExpression siblingExpression) {
        XBlockExpression containerBlock = siblingExpression.eContainer() instanceof XBlockExpression ? (XBlockExpression)siblingExpression.eContainer() : null;
        XExpression context = siblingExpression;
        if (containerBlock != null && !containerBlock.getExpressions().isEmpty()) {
            context = (EObject)containerBlock.getExpressions().get(containerBlock.getExpressions().size() - 1);
        }
        IExpressionScope expressionScope = this.batchTypeResolver.resolveTypes((EObject)context).getExpressionScope((EObject)context, IExpressionScope.Anchor.AFTER);
        this.featureCallScope = expressionScope.getFeatureScope();
    }

    public void checkNewFeatureName(String newFeatureName, boolean isLookupInScope, RefactoringStatus status) {
        if (Strings.isEmpty((String)newFeatureName)) {
            status.addFatalError("Choose a name");
            return;
        }
        try {
            Object value = this.valueConverterService.toValue(newFeatureName, "ValidID", null);
            this.valueConverterService.toString(value, "ValidID");
        }
        catch (ValueConverterException exc) {
            status.addFatalError(exc.getMessage());
        }
        if (Character.isUpperCase(newFeatureName.charAt(0))) {
            status.addError("Discouraged name '" + newFeatureName + "'. Name should start with a lowercase letter. ");
        }
        if (this.isKeyword(newFeatureName)) {
            status.addFatalError("'" + newFeatureName + "' is keyword.");
        }
        if (Primitives.forName((String)newFeatureName) != null) {
            status.addFatalError("'" + newFeatureName + "' is reserved.");
        }
        if (isLookupInScope && this.featureCallScope != null && this.isAlreadyDefined(newFeatureName)) {
            status.addError("The name '" + newFeatureName + "' is already defined in this scope.");
        }
    }

    protected boolean isKeyword(String newFeatureName) {
        return this.allKeywords.contains(newFeatureName);
    }

    protected boolean isAlreadyDefined(String newFeatureName) {
        IEObjectDescription existing = this.featureCallScope.getSingleElement(QualifiedName.create((String)newFeatureName));
        return existing != null;
    }

    public String getDefaultName(XExpression expression) {
        String defaultName;
        String currentName = defaultName = this.getFancyDefaultName(expression);
        int count = 0;
        while (this.isKeyword(currentName) || this.isAlreadyDefined(currentName)) {
            currentName = String.valueOf(defaultName) + ++count;
        }
        return currentName;
    }

    protected String getFancyDefaultName(XExpression expression) {
        if (expression instanceof XMemberFeatureCall || expression instanceof XFeatureCall) {
            String featureName = ((XAbstractFeatureCall)expression).getFeature().getSimpleName();
            if (featureName.startsWith("get")) {
                return this.toVariableName(featureName.substring(3));
            }
            return this.toVariableName(featureName);
        }
        if (expression instanceof XClosure) {
            return "function";
        }
        LightweightTypeReference type = this.batchTypeResolver.resolveTypes((EObject)expression).getActualType(expression);
        if (type != null) {
            if (type.isPrimitive()) {
                return type.getSimpleName().substring(0, 1);
            }
            return this.toVariableName(type.getSimpleName());
        }
        return "";
    }

    protected String toVariableName(String name) {
        if (name.toUpperCase().equals(name)) {
            StringBuilder camelCaseBuilder = new StringBuilder();
            boolean isFirst = true;
            String[] stringArray = name.toLowerCase().split("_");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fragment = stringArray[n2];
                camelCaseBuilder.append(isFirst ? fragment : StringExtensions.toFirstUpper((String)fragment));
                isFirst = false;
                ++n2;
            }
            return camelCaseBuilder.toString();
        }
        return StringExtensions.toFirstLower((String)name);
    }
}

