/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.ScopeStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedAppendableState {
    private int indentationlevel = 0;
    private final String indentation;
    private final String lineSeparator;
    private final ScopeStack scopes;
    private final ImportManager importManager;

    public SharedAppendableState(String indentation, String lineSeparator, ImportManager importManager) {
        this.indentation = indentation;
        this.lineSeparator = lineSeparator;
        this.importManager = importManager;
        this.scopes = new ScopeStack();
        this.openScope();
    }

    public SharedAppendableState(ImportManager importManager) {
        this("  ", "\n", importManager);
    }

    public void appendNewLineAndIndentation(IAcceptor<String> content) {
        content.accept((Object)this.lineSeparator);
        int i = 0;
        while (i < this.indentationlevel) {
            content.accept((Object)this.indentation);
            ++i;
        }
    }

    public void increaseIndentation() {
        ++this.indentationlevel;
    }

    public void decreaseIndentation() {
        if (this.indentationlevel == 0) {
            throw new IllegalStateException("Can't reduce indentation level. It's already zero.");
        }
        --this.indentationlevel;
    }

    public void openScope() {
        this.scopes.openScope(false);
    }

    public void openPseudoScope() {
        this.scopes.openScope(true);
    }

    public String declareVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, false);
    }

    public String declareSyntheticVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, true);
    }

    public void closeScope() {
        this.scopes.closeScope();
    }

    public void appendType(JvmType type, IAcceptor<String> content) {
        if (this.hasObject(type.getSimpleName())) {
            content.accept((Object)type.getQualifiedName('.'));
        } else {
            StringBuilder builder = new StringBuilder();
            this.importManager.appendType(type, builder);
            content.accept((Object)builder.toString());
        }
    }

    public void appendType(Class<?> type, IAcceptor<String> content) {
        if (this.hasObject(type.getSimpleName())) {
            content.accept((Object)type.getCanonicalName());
        } else {
            StringBuilder builder = new StringBuilder();
            this.importManager.appendType(type, builder);
            content.accept((Object)builder.toString());
        }
    }

    public List<String> getImports() {
        return this.importManager.getImports();
    }

    public String getName(Object key) {
        String result = this.scopes.getName(key);
        if (result == null) {
            throw new IllegalStateException("Cannot get name for " + key);
        }
        return result;
    }

    public boolean hasName(Object key) {
        return this.scopes.getName(key) != null;
    }

    public Object getObject(String name) {
        Object result = this.scopes.get(name);
        if (result == null) {
            throw new IllegalStateException("Cannot get object for " + name);
        }
        return result;
    }

    public boolean hasObject(String name) {
        return this.scopes.get(name) != null;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    ImportManager getImportManager() {
        return this.importManager;
    }

    String getIndentationString() {
        return this.indentation;
    }
}

