/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.RootNoExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.RootTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootExpressionTypeComputationState
extends ExpressionTypeComputationState {
    private final LightweightTypeReference expectedType;
    private LightweightTypeReference expectedReturnType;

    protected RootExpressionTypeComputationState(StackedResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, AbstractTypeComputationState parent, XExpression expression, LightweightTypeReference expectedType) {
        super(resolvedTypes, featureScopeSession, parent, expression);
        this.expectedType = expectedType;
        this.expectedReturnType = expectedType;
    }

    @Override
    public List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState) {
        AbstractTypeExpectation result = this.createTypeExpectation(this.expectedType, actualState, true, false);
        return Collections.singletonList(result);
    }

    @Override
    protected List<AbstractTypeExpectation> getReturnExpectations(AbstractTypeComputationState actualState, boolean asActualExpectation) {
        AbstractTypeExpectation result = this.createTypeExpectation(this.expectedReturnType, actualState, !asActualExpectation, true);
        return Collections.singletonList(result);
    }

    protected AbstractTypeExpectation createTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState actualState, boolean voidAllowed, boolean returnType) {
        AbstractRootTypeExpectation result = null;
        if (expectedType != null) {
            LightweightTypeReference copied = expectedType.copyInto(actualState.getReferenceOwner());
            result = new RootTypeExpectation(copied, actualState);
        } else {
            result = returnType ? new PendingRootExpectation(actualState, this, voidAllowed) : new RootNoExpectation(actualState, voidAllowed);
        }
        return result;
    }

    protected static class PendingRootExpectation
    extends RootNoExpectation {
        private RootExpressionTypeComputationState rootState;

        public PendingRootExpectation(AbstractTypeComputationState state, RootExpressionTypeComputationState rootState, boolean voidAllowed) {
            super(state, voidAllowed);
            this.rootState = rootState;
        }

        public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
            if (Arrays.contains((Object[])hints, (Object)((Object)ConformanceHint.EXPLICIT_VOID_RETURN))) {
                this.rootState.expectedReturnType = type;
            }
            super.acceptActualType(type, hints);
        }

        public LightweightTypeReference getExpectedType() {
            if (this.rootState.expectedReturnType != null) {
                return this.rootState.expectedReturnType;
            }
            return super.getExpectedType();
        }

        public boolean isNoTypeExpectation() {
            if (this.rootState.expectedReturnType != null) {
                return false;
            }
            return super.isNoTypeExpectation();
        }

        public boolean isVoidTypeAllowed() {
            if (this.rootState.expectedReturnType != null) {
                return true;
            }
            return super.isVoidTypeAllowed();
        }
    }
}

