/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

public class WrapperTypeLookup {
    private static LightweightTypeReference findTopLevelType(LightweightTypeReference context, String typeName) {
        ITypeReferenceOwner owner = context.getOwner();
        ResourceSet resourceSet = owner.getContextResourceSet();
        Resource typeResource = resourceSet.getResource(URIHelperConstants.OBJECTS_URI.appendSegment(typeName), true);
        EList contents = typeResource.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        JvmType type = (JvmType)contents.get(0);
        if (type == null) {
            return null;
        }
        return new ParameterizedTypeReference(owner, type);
    }

    public static LightweightTypeReference getWrapperType(LightweightTypeReference context, Primitives.Primitive primitiveKind) {
        switch (primitiveKind) {
            case Boolean: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Boolean");
            }
            case Byte: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Byte");
            }
            case Char: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Character");
            }
            case Double: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Double");
            }
            case Float: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Float");
            }
            case Int: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Integer");
            }
            case Long: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Long");
            }
            case Short: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Short");
            }
            case Void: {
                return WrapperTypeLookup.findTopLevelType(context, "java.lang.Void");
            }
        }
        throw new IllegalArgumentException("Unknown primitive type: " + primitiveKind);
    }
}

