/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceAcceptor
implements IReferenceFinder.Acceptor {
    private final IAcceptor<IReferenceDescription> delegate;
    private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private Resource currentResource;
    private Map<EObject, URI> exportedContainersInCurrentResource;

    protected ReferenceAcceptor(IAcceptor<IReferenceDescription> delegate, IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        this.delegate = delegate;
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
    }

    public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
        if (this.currentResource == null || source.eResource() != this.currentResource) {
            this.computeExportedObjectsMap(source);
            this.currentResource = source.eResource();
        }
        this.accept((IReferenceDescription)this.createReferenceDescription(sourceURI, targetURI, eReference, index, this.findExportedContainer(source)));
    }

    private void computeExportedObjectsMap(EObject source) {
        Resource resource = source.eResource();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider != null) {
            IResourceDescription resourceDescription = resourceServiceProvider.getResourceDescriptionManager().getResourceDescription(resource);
            this.exportedContainersInCurrentResource = Maps.newHashMap();
            for (IEObjectDescription description : resourceDescription.getExportedObjects()) {
                EObject instance = description.getEObjectOrProxy();
                if (instance.eIsProxy()) {
                    instance = resource.getEObject(description.getEObjectURI().fragment());
                }
                this.exportedContainersInCurrentResource.put(instance, description.getEObjectURI());
            }
        } else {
            this.exportedContainersInCurrentResource = Collections.emptyMap();
        }
    }

    protected URI findExportedContainer(EObject source) {
        if (this.exportedContainersInCurrentResource.isEmpty()) {
            return null;
        }
        URI result = this.exportedContainersInCurrentResource.get(source);
        while (result == null) {
            if (this.exportedContainersInCurrentResource.containsKey(source)) {
                return result;
            }
            if ((source = source.eContainer()) == null) {
                return null;
            }
            result = this.exportedContainersInCurrentResource.get(source);
        }
        this.exportedContainersInCurrentResource.put(source, result);
        return result;
    }

    public void accept(IReferenceDescription description) {
        this.delegate.accept((Object)description);
    }

    protected DefaultReferenceDescription createReferenceDescription(URI sourceURI, URI targetURI, EReference eReference, int index, URI containerURI) {
        return new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, containerURI);
    }
}

