/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;

public class NestedTypeAwareImportNormalizerWithDotSeparator
extends AbstractNestedTypeAwareImportNormalizer {
    public NestedTypeAwareImportNormalizerWithDotSeparator(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        super(importedNamespace, wildcard, ignoreCase);
    }

    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.hasWildCard()) {
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix()) && fullyQualifiedName.getSegmentCount() != this.getImportedNamespacePrefix().getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount());
            }
        } else {
            QualifiedName withoutDollars;
            if (fullyQualifiedName.equals((Object)this.getImportedNamespacePrefix())) {
                return QualifiedName.create((String)fullyQualifiedName.getLastSegment());
            }
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix())) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
            }
            int segmentCount = fullyQualifiedName.getSegmentCount();
            ArrayList segments = Lists.newArrayListWithExpectedSize((int)segmentCount);
            int i = 0;
            while (i < segmentCount) {
                String segment = fullyQualifiedName.getSegment(i);
                segments.addAll(Strings.split((String)segment, (char)'$'));
                ++i;
            }
            if (segments.size() > segmentCount && (withoutDollars = QualifiedName.create((List)segments)).startsWith(this.getImportedNamespacePrefix())) {
                return withoutDollars.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
            }
        }
        return null;
    }

    protected QualifiedName resolveNonWildcard(QualifiedName relativeName) {
        if (relativeName.getSegmentCount() == 1) {
            List split = Strings.split((String)relativeName.getFirstSegment(), (char)'$');
            if (split.size() == 0) {
                return this.internalResolve(relativeName);
            }
            return this.internalResolve(QualifiedName.create((List)split));
        }
        StringBuilder concatenated = new StringBuilder();
        int i = 0;
        while (i < relativeName.getSegmentCount()) {
            String segment = relativeName.getSegment(i);
            if (segment.indexOf(36) == -1) {
                if (concatenated.length() != 0) {
                    concatenated.append('$');
                }
            } else {
                return null;
            }
            concatenated.append(segment);
            ++i;
        }
        return this.internalResolve(relativeName);
    }

    protected QualifiedName internalResolve(QualifiedName relativeName) {
        QualifiedName importedNamespace = this.getImportedNamespacePrefix();
        if (importedNamespace.getLastSegment().equals(relativeName.getFirstSegment())) {
            return importedNamespace.skipLast(1).append(relativeName);
        }
        return null;
    }
}

