/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.validation.IResourceValidator;

public class DefaultResourceServiceProvider
implements IResourceServiceProvider,
IResourceServiceProviderExtension {
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject(optional=true)
    private IEncodingProvider encodingProvider;
    @Inject
    private Injector injector;

    @Override
    public IContainer.Manager getContainerManager() {
        return this.containerManager;
    }

    @Override
    public IResourceDescription.Manager getResourceDescriptionManager() {
        return this.resourceDescriptionManager;
    }

    @Override
    public IResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    @Override
    public boolean canHandle(URI uri) {
        return this.fileExtensionProvider.isValid(uri.fileExtension());
    }

    @Override
    public IEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    @Override
    public <T> T get(Class<T> t) {
        try {
            return (T)this.injector.getInstance(t);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    @Override
    public boolean isReadOnly(URI uri) {
        return uri.isArchive();
    }
}

