/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.actions;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.eclipse.xtext.ui.editor.XtextEditor;

public interface IActionContributor {
    public void contributeActions(XtextEditor var1);

    public void editorDisposed(XtextEditor var1);

    public static class CompositeImpl
    implements IActionContributor {
        @Inject
        private Injector injector;
        private List<IActionContributor> children = Lists.newArrayList();

        public void contributeActions(XtextEditor editor) {
            List bindingsByType = this.injector.findBindingsByType(TypeLiteral.get(IActionContributor.class));
            for (Binding binding : bindingsByType) {
                IActionContributor actionContributor = (IActionContributor)this.injector.getInstance(binding.getKey());
                actionContributor.contributeActions(editor);
                this.children.add(actionContributor);
            }
        }

        public void editorDisposed(XtextEditor editor) {
            for (IActionContributor actionContributor : this.children) {
                actionContributor.editorDisposed(editor);
            }
        }
    }
}

