/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableScope
extends AbstractSessionBasedScope {
    public LocalVariableScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall) {
        super(parent, session, featureCall);
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.getSession().getLocalElements();
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        IEObjectDescription element = this.getSession().getLocalElement(name);
        if (element == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    protected boolean looksLikeLocalVariable() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XFeatureCall) {
            boolean result = !featureCall.isExplicitOperationCallOrBuilderSyntax();
            return result;
        }
        return false;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        Collection<IEObjectDescription> localElements = this.getLocalElementsByName(name);
        if (localElements.isEmpty()) {
            return this.getParent().getElements(name);
        }
        if (!this.looksLikeLocalVariable()) {
            return localElements;
        }
        Iterable parentElements = this.getParentElements((Provider)new Provider<Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> get() {
                return LocalVariableScope.this.getParent().getElements(name);
            }
        });
        Iterable result = Iterables.concat(localElements, (Iterable)parentElements);
        return result;
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        if (this.getShadowingKey(fromParent).equals(fromParent.getName().toString())) {
            boolean result = this.getSession().getLocalElement(fromParent.getName()) != null;
            return result;
        }
        return false;
    }
}

