/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.inject.Singleton;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;

public abstract class AbstractTypeComputer
implements ITypeComputer {
    public AbstractTypeComputer() {
        this.checkIsSingelton();
    }

    protected final void checkIsSingelton() {
        Singleton singleton = this.getClass().getAnnotation(Singleton.class);
        if (singleton == null) {
            throw new IllegalStateException("The class " + this.getClass().getSimpleName() + " must be annotated with @Singleton annotation.");
        }
    }

    public void computeTypes(XExpression expression, ITypeComputationState state) {
        this._computeTypes(expression, state);
    }

    protected void _computeTypes(XExpression expression, ITypeComputationState state) {
        throw new UnsupportedOperationException("Missing type computation for expression type: " + expression.eClass().getName() + " / " + state);
    }
}

