/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;

public class XtendDoubleClickStrategyProvider
extends DoubleClickStrategyProvider {
    public ITextDoubleClickStrategy getStrategy(ISourceViewer sourceViewer, String contentType, String documentPartitioning) {
        if ("__rich_string".equals(contentType)) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion getSelectedRegion(IDocument document, ITypedRegion completePartition) throws BadLocationException {
                    String content = document.get(completePartition.getOffset(), completePartition.getLength());
                    int trimLeft = 1;
                    if (content.startsWith("'''")) {
                        trimLeft = 3;
                    }
                    int trimRight = 0;
                    if (content.endsWith("'''")) {
                        trimRight = 3;
                    } else if (content.endsWith("''")) {
                        trimRight = 2;
                    } else if (content.endsWith("'") || content.endsWith("\u00ab")) {
                        trimRight = 1;
                    }
                    return new Region(completePartition.getOffset() + trimLeft, completePartition.getLength() - trimLeft - trimRight);
                }
            };
        }
        return super.getStrategy(sourceViewer, contentType, documentPartitioning);
    }
}

