/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.builder.preferences.Messages;
import org.eclipse.xtext.builder.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.builder.preferences.ScrolledPageContent;
import org.eclipse.xtext.generator.OutputConfiguration;

public class BuilderConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = "BuilderConfigurationBlock";
    private EclipseOutputConfigurationProvider configurationProvider;

    public BuilderConfigurationBlock(IProject project, IPreferenceStore preferenceStore, EclipseOutputConfigurationProvider configurationProvider, IWorkbenchPreferenceContainer container) {
        super(project, BuilderConfigurationBlock.getKeys(project, configurationProvider), preferenceStore, container);
        this.configurationProvider = configurationProvider;
    }

    private static String[] getKeys(IProject project, EclipseOutputConfigurationProvider configurationProvider) {
        HashSet keys = Sets.newHashSet((Object[])new String[]{"autobuilding", "is_project_specific"});
        Set<OutputConfiguration> outputConfigurations = configurationProvider.getOutputConfigurations(project);
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "directory"));
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "createDirectory"));
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "cleanDirectory"));
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "override"));
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "derived"));
            keys.add(BuilderPreferenceAccess.getKey(outputConfiguration, "cleanupDerived"));
        }
        return keys.toArray(new String[0]);
    }

    protected Control createContents(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        String[] trueFalseValues = new String[]{"true", "false"};
        int columns = 3;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        String label = Messages.BuilderConfigurationBlock_GeneralSection_Label;
        ExpandableComposite excomposite = this.createStyleSection(composite, label, columns);
        Composite othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(columns, false));
        this.addCheckBox(othersComposite, Messages.BuilderPreferencePage_GenerateAuto, "autobuilding", trueFalseValues, 0);
        Set<OutputConfiguration> outputConfigurations = this.configurationProvider.getOutputConfigurations(this.getProject());
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            label = outputConfiguration.getDescription();
            excomposite = this.createStyleSection(composite, label, columns);
            othersComposite = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)othersComposite);
            othersComposite.setLayout((Layout)new GridLayout(columns, false));
            this.addTextField(othersComposite, Messages.OutputConfigurationPage_Directory, BuilderPreferenceAccess.getKey(outputConfiguration, "directory"), 0, 200);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CreateDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "createDirectory"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_OverrideExistingResources, BuilderPreferenceAccess.getKey(outputConfiguration, "override"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CreatesDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "derived"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CleanupDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanupDerived"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CleanDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanDirectory"), trueFalseValues, 0);
        }
        IDialogSettings section = Activator.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(section);
        return pageContent;
    }

    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(settings);
        super.dispose();
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.BuilderConfigurationBlock_SettingsChanged_Title;
        String message = workspaceSettings ? Messages.BuilderConfigurationBlock_SettingsChanged_WorkspaceBuild : Messages.BuilderConfigurationBlock_SettingsChanged_ProjectBuild;
        return new String[]{title, message};
    }

    protected Job getBuildJob(IProject project) {
        BuildJob buildJob = new BuildJob(Messages.BuilderConfigurationBlock_BuildJob_Title0, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    private static final class BuildJob
    extends Job {
        private final IProject project;

        private BuildJob(String name, IProject project) {
            super(name);
            this.project = project;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.project == null) {
                return true;
            }
            return this.project != null && this.project.equals((Object)other.project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    BuildJob job;
                    if (buildJobs[i] != this && buildJobs[i] instanceof BuildJob && (job = (BuildJob)buildJobs[i]).isCoveredBy(this)) {
                        buildJobs[i].cancel();
                    }
                    ++i;
                }
            }
            try {
                try {
                    if (this.project != null) {
                        monitor.beginTask(String.format(Messages.BuilderConfigurationBlock_BuildJob_TitleBuildProject_TaskName, TextProcessor.process((String)this.project.getName(), (String)":.")), 2);
                        this.project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.beginTask(Messages.BuilderConfigurationBlock_BuildJob_TitleBuildAll_TaskName, 2);
                        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

