/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.DirtyStateManager;
import org.eclipse.xtext.ui.editor.DocumentBasedDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IValidationJobScheduler;
import org.eclipse.xtext.ui.editor.Messages;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtyStateEditorSupport
implements IXtextModelListener,
IResourceDescription.Event.Listener,
VerifyListener {
    private static ISchedulingRule SCHEDULING_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IStateChangeEventBroker stateChangeEventBroker;
    @Inject
    private DocumentBasedDirtyResource dirtyResource;
    private ClientAwareDirtyResource delegatingClientAwareResource;
    @Inject
    private IConcurrentEditingCallback concurrentEditingWarningDialog;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject(optional=true)
    private DescriptionUtils descriptionUtils;
    @Inject(optional=true)
    private IValidationJobScheduler validationJobScheduler;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private volatile IDirtyStateEditorSupportClient currentClient;
    private volatile boolean isDirty;
    private UpdateEditorStateJob updateEditorStateJob;

    public void initializeDirtyStateSupport(IDirtyStateEditorSupportClient client) {
        if (this.currentClient != null) {
            throw new IllegalStateException("editor was already assigned");
        }
        this.currentClient = client;
        this.isDirty = false;
        IXtextDocument document = client.getDocument();
        document.addModelListener(this);
        this.initDirtyResource(document);
        this.stateChangeEventBroker.addListener(this);
        client.addVerifyListener(this);
        this.scheduleValidationJobIfNecessary();
    }

    private void scheduleValidationJobIfNecessary() {
        if (this.validationJobScheduler != null && this.currentClient != null) {
            this.validationJobScheduler.scheduleInitialValidation(this.currentClient.getDocument());
        }
    }

    public void verifyText(VerifyEvent e) {
        if (this.isDirty || !e.doit) {
            return;
        }
        e.doit = this.doVerify();
        if (e.doit) {
            this.isDirty = true;
        }
    }

    public boolean doVerify() {
        if (!this.dirtyStateManager.manageDirtyState(this.delegatingClientAwareResource)) {
            ClientAwareDirtyResource clientAwareDirtyResource;
            IDirtyResource other;
            if (this.dirtyStateManager instanceof DirtyStateManager && (other = ((DirtyStateManager)this.dirtyStateManager).getDirtyResource(this.delegatingClientAwareResource.getURI())) instanceof ClientAwareDirtyResource && !(clientAwareDirtyResource = (ClientAwareDirtyResource)other).isDirty()) {
                clientAwareDirtyResource.discardThisResource();
                return this.doVerify();
            }
            if (!this.isConcurrentEditingIgnored()) {
                this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
                return false;
            }
        }
        return true;
    }

    public boolean isEditingPossible(IDirtyStateEditorSupportClient client) {
        if (this.currentClient == null || this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        if (this.isDirty) {
            return true;
        }
        if (!this.doVerify()) {
            return false;
        }
        this.isDirty = true;
        return true;
    }

    protected boolean isConcurrentEditingIgnored() {
        return this.concurrentEditingWarningDialog.isConcurrentEditingIgnored(this.currentClient);
    }

    protected void initDirtyResource(IXtextDocument document) {
        this.dirtyResource.connect(document);
        this.delegatingClientAwareResource = new ClientAwareDirtyResource();
    }

    public void removeDirtyStateSupport(IDirtyStateEditorSupportClient client) {
        IXtextDocument document;
        if (this.currentClient == null || this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        client.removeVerifyListener(this);
        this.stateChangeEventBroker.removeListener(this);
        if (this.dirtyResource.isInitialized()) {
            this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
        }
        if ((document = client.getDocument()) == null) {
            document = this.dirtyResource.getUnderlyingDocument();
        }
        if (document != null) {
            this.dirtyResource.disconnect(document);
            document.removeModelListener(this);
        }
        this.delegatingClientAwareResource = null;
        this.currentClient = null;
    }

    public void markEditorClean(IDirtyStateEditorSupportClient client) {
        if (this.currentClient == null || this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
        this.isDirty = false;
        IResourceDescription cleanDescription = this.resourceDescriptions.getResourceDescription(this.delegatingClientAwareResource.getURI());
        if (cleanDescription != null) {
            this.dirtyResource.copyState(cleanDescription);
        }
    }

    public void descriptionsChanged(IResourceDescription.Event event) {
        if (!this.getDirtyResource().isInitialized()) {
            return;
        }
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (delta.getOld() != this.getDirtyResource().getDescription() && delta.getNew() != this.getDirtyResource().getDescription()) continue;
            return;
        }
        this.scheduleUpdateEditorJob(event);
    }

    public void scheduleUpdateEditorJob(IResourceDescription.Event event) {
        UpdateEditorStateJob job = this.updateEditorStateJob;
        if (job == null) {
            this.updateEditorStateJob = job = this.createUpdateEditorJob();
        }
        job.scheduleFor(event);
    }

    protected UpdateEditorStateJob createUpdateEditorJob() {
        return new UpdateEditorStateJob(SCHEDULING_RULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(XtextResource resource) {
        if (resource == null || !this.dirtyResource.isInitialized()) {
            return;
        }
        if (this.isDirty || (!resource.isTrackingModification() || resource.isModified()) && this.currentClient.isDirty() && this.dirtyStateManager.manageDirtyState(this.delegatingClientAwareResource)) {
            IDirtyStateManager iDirtyStateManager = this.dirtyStateManager;
            synchronized (iDirtyStateManager) {
                IResourceDescription.Manager resourceDescriptionManager = resource.getResourceServiceProvider().getResourceDescriptionManager();
                IResourceDescription newDescription = resourceDescriptionManager.getResourceDescription((Resource)resource);
                if (this.haveEObjectDescriptionsChanged(newDescription, resourceDescriptionManager)) {
                    this.dirtyResource.copyState(newDescription);
                    this.dirtyStateManager.announceDirtyStateChanged(this.delegatingClientAwareResource);
                }
            }
        }
    }

    @Deprecated
    public boolean haveEObjectDescriptionsChanged(IResourceDescription newDescription) {
        IResourceDescription.Manager resourceDescriptionManager = this.resourceServiceProviderRegistry.getResourceServiceProvider(newDescription.getURI()).getResourceDescriptionManager();
        return this.haveEObjectDescriptionsChanged(newDescription, resourceDescriptionManager);
    }

    public boolean haveEObjectDescriptionsChanged(IResourceDescription newDescription, IResourceDescription.Manager resourceDescriptionManager) {
        return resourceDescriptionManager.createDelta(this.dirtyResource.getDescription(), newDescription).haveEObjectDescriptionsChanged();
    }

    protected Collection<Resource> collectAffectedResources(XtextResource resource, IResourceDescription.Event event) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)4);
        ResourceSet resourceSet = resource.getResourceSet();
        URIConverter converter = resourceSet.getURIConverter();
        HashSet normalizedURIs = Sets.newHashSetWithExpectedSize((int)event.getDeltas().size());
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            normalizedURIs.add(converter.normalize(delta.getUri()));
        }
        EList resources = resourceSet.getResources();
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            if (res != resource && res != null) {
                URI uri = res.getURI();
                try {
                    uri = converter.normalize(uri);
                }
                catch (ClasspathUriResolutionException classpathUriResolutionException) {
                    // empty catch block
                }
                if (normalizedURIs.contains(uri)) {
                    result.add(res);
                }
            }
            ++i;
        }
        return result;
    }

    protected boolean isReparseRequired(XtextResource resource, IResourceDescription.Event event) {
        IResourceDescription originalDescription;
        IResourceDescription.Manager resourceDescriptionManager = resource.getResourceServiceProvider().getResourceDescriptionManager();
        IResourceDescription description = resourceDescriptionManager.getResourceDescription((Resource)resource);
        if (resourceDescriptionManager.isAffected((Collection)event.getDeltas(), description, this.resourceDescriptions)) {
            return true;
        }
        if (!this.isDirty() && !this.dirtyStateManager.hasContent(resource.getURI()) && (originalDescription = this.resourceDescriptions.getResourceDescription(resource.getURI())) != null && this.descriptionUtils != null) {
            Set outgoingReferences = this.descriptionUtils.collectOutgoingReferences(originalDescription);
            for (IResourceDescription.Delta delta : event.getDeltas()) {
                if (!delta.haveEObjectDescriptionsChanged() || !outgoingReferences.contains(delta.getUri())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected ChangedResourceDescriptionDelta createDelta(IResourceDescription.Delta delta, IResourceDescription.Delta prev) {
        return new ChangedResourceDescriptionDelta(prev.getOld(), delta.getNew());
    }

    public IDirtyStateManager getDirtyStateManager() {
        return this.dirtyStateManager;
    }

    public void setDirtyStateManager(IDirtyStateManager dirtyStateManager) {
        this.dirtyStateManager = dirtyStateManager;
    }

    public IStateChangeEventBroker getStateChangeEventBroker() {
        return this.stateChangeEventBroker;
    }

    public void setStateChangeEventBroker(IStateChangeEventBroker stateChangeEventBroker) {
        this.stateChangeEventBroker = stateChangeEventBroker;
    }

    public void setConcurrentEditingWarningDialog(IConcurrentEditingCallback concurrentEditingWarningDialog) {
        this.concurrentEditingWarningDialog = concurrentEditingWarningDialog;
    }

    public IConcurrentEditingCallback getConcurrentEditingWarningDialog() {
        return this.concurrentEditingWarningDialog;
    }

    public void setDirtyResource(DocumentBasedDirtyResource dirtyResource) {
        this.dirtyResource = dirtyResource;
    }

    public DocumentBasedDirtyResource getDirtyResource() {
        return this.dirtyResource;
    }

    public void setResourceDescriptions(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    private class ClientAwareDirtyResource
    implements IDirtyResource {
        private ClientAwareDirtyResource() {
        }

        public String getContents() {
            return DirtyStateEditorSupport.this.dirtyResource.getContents();
        }

        public String getActualContents() {
            return DirtyStateEditorSupport.this.dirtyResource.getActualContents();
        }

        public IResourceDescription getDescription() {
            return DirtyStateEditorSupport.this.dirtyResource.getDescription();
        }

        public URI getURI() {
            return DirtyStateEditorSupport.this.dirtyResource.getURI();
        }

        private boolean isDirty() {
            return DirtyStateEditorSupport.this.currentClient.isDirty();
        }

        private void discardThisResource() {
            DirtyStateEditorSupport.this.markEditorClean(DirtyStateEditorSupport.this.currentClient);
        }
    }

    @ImplementedBy(value=InteractiveConcurrentEditingQuestion.class)
    public static interface IConcurrentEditingCallback {
        public boolean isConcurrentEditingIgnored(IDirtyStateEditorSupportClient var1);
    }

    public static interface IDirtyStateEditorSupportClient {
        public IXtextDocument getDocument();

        public boolean isDirty();

        public Shell getShell();

        public void addVerifyListener(VerifyListener var1);

        public void removeVerifyListener(VerifyListener var1);
    }

    public static class InteractiveConcurrentEditingQuestion
    implements IConcurrentEditingCallback {
        public boolean isConcurrentEditingIgnored(IDirtyStateEditorSupportClient client) {
            String title = Messages.DirtyStateEditorSupport_ConcurrentChangeDialog_Title;
            String message = Messages.DirtyStateEditorSupport_ConcurrentChangeDialog_Message;
            return MessageDialog.openQuestion((Shell)client.getShell(), (String)title, (String)message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateEditorStateJob
    extends Job {
        private Queue<IResourceDescription.Delta> pendingChanges;

        protected UpdateEditorStateJob(ISchedulingRule rule) {
            this(rule, Messages.DirtyStateEditorSupport_JobName);
        }

        protected UpdateEditorStateJob(ISchedulingRule rule, String name) {
            super(name);
            this.setRule(rule);
            this.pendingChanges = new ConcurrentLinkedQueue<IResourceDescription.Delta>();
        }

        protected void scheduleFor(IResourceDescription.Event event) {
            this.cancel();
            this.pendingChanges.addAll((Collection<IResourceDescription.Delta>)event.getDeltas());
            this.schedule(this.getDelay());
        }

        protected int getDelay() {
            return 500;
        }

        protected Pair<IResourceDescription.Event, Integer> mergePendingDeltas() {
            LinkedHashMap uriToDelta = Maps.newLinkedHashMap();
            Iterator iter = this.pendingChanges.iterator();
            int size = 0;
            while (iter.hasNext()) {
                IResourceDescription.Delta delta = (IResourceDescription.Delta)iter.next();
                URI uri = delta.getUri();
                IResourceDescription.Delta prev = (IResourceDescription.Delta)uriToDelta.get(uri);
                if (prev == null) {
                    uriToDelta.put(uri, delta);
                } else if (prev.getOld() != delta.getNew()) {
                    uriToDelta.put(uri, DirtyStateEditorSupport.this.createDelta(delta, prev));
                } else {
                    uriToDelta.remove(uri);
                }
                ++size;
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(uriToDelta.values(), (IResourceDescription.Event.Source)DirtyStateEditorSupport.this.dirtyStateManager);
            return Tuples.create((Object)event, (Object)size);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            IDirtyStateEditorSupportClient myClient = DirtyStateEditorSupport.this.currentClient;
            if (myClient == null || monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            final IXtextDocument document = myClient.getDocument();
            if (document == null) {
                return Status.OK_STATUS;
            }
            final boolean[] isReparseRequired = new boolean[1];
            final Pair<IResourceDescription.Event, Integer> event = this.mergePendingDeltas();
            final Collection affectedResources = (Collection)document.readOnly((IUnitOfWork)new IUnitOfWork<Collection<Resource>, XtextResource>(){

                public Collection<Resource> exec(XtextResource resource) throws Exception {
                    if (resource == null || resource.getResourceSet() == null) {
                        return null;
                    }
                    Collection<Resource> affectedResources = DirtyStateEditorSupport.this.collectAffectedResources(resource, (IResourceDescription.Event)event.getFirst());
                    if (monitor.isCanceled()) {
                        return Collections.emptySet();
                    }
                    isReparseRequired[0] = DirtyStateEditorSupport.this.isReparseRequired(resource, (IResourceDescription.Event)event.getFirst());
                    return affectedResources;
                }
            });
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (affectedResources != null && !affectedResources.isEmpty() || isReparseRequired[0]) {
                Assert.isLegal((boolean)(document instanceof XtextDocument));
                ((XtextDocument)document).internalModify(new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        if (resource == null || resource.getResourceSet() == null) {
                            return;
                        }
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (affectedResources != null) {
                            for (Resource affectedResource : affectedResources) {
                                affectedResource.unload();
                                resourceSet.getResources().remove((Object)affectedResource);
                            }
                        }
                        resource.reparse(document.get());
                    }
                });
            }
            int i = 0;
            while (i < (Integer)event.getSecond()) {
                this.pendingChanges.poll();
                ++i;
            }
            return Status.OK_STATUS;
        }
    }
}

