/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;

public class TypeScopeProvider {
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;

    public IScope createTypeScope(IScope parentScope, EObject context, EReference reference) {
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(context);
        if (logicalContainer != null) {
            return this.createTypeParameterScope(parentScope, logicalContainer, reference);
        }
        return parentScope;
    }

    protected IScope createTypeParameterScope(IScope parentScope, JvmIdentifiableElement context, EReference reference) {
        if (context == null) {
            return parentScope;
        }
        if (context.eContainer() instanceof JvmIdentifiableElement) {
            parentScope = this.createTypeParameterScope(parentScope, (JvmIdentifiableElement)context.eContainer(), reference);
        }
        if (context instanceof JvmTypeParameterDeclarator) {
            ArrayList descriptions = Lists.newArrayList();
            JvmTypeParameterDeclarator typeParamDeclarator = (JvmTypeParameterDeclarator)context;
            for (JvmTypeParameter param : typeParamDeclarator.getTypeParameters()) {
                if (param.getSimpleName() == null) continue;
                QualifiedName paramName = QualifiedName.create((String)param.getSimpleName());
                descriptions.add(EObjectDescription.create((QualifiedName)paramName, (EObject)param));
            }
            if (!descriptions.isEmpty()) {
                return MapBasedScope.createScope((IScope)parentScope, (Collection)descriptions);
            }
        }
        return parentScope;
    }
}

