/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseFileSystemSupportImpl
extends AbstractFileSystemSupport {
    @Inject
    private IWorkspaceRoot _workspaceRoot;

    public IWorkspaceRoot getWorkspaceRoot() {
        return this._workspaceRoot;
    }

    public void setWorkspaceRoot(IWorkspaceRoot workspaceRoot) {
        this._workspaceRoot = workspaceRoot;
    }

    protected IFile getEclipseFile(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        return _workspaceRoot.getFile((IPath)_path);
    }

    protected IFolder getEclipseFolder(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        return _workspaceRoot.getFolder((IPath)_path);
    }

    protected IContainer getEclipseContainer(Path path) {
        List _segments;
        IWorkspaceRoot _xblockexpression = null;
        boolean _isAbsolute = path.isAbsolute();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The given path has to be absolute: '");
        _builder.append((Object)path, "");
        _builder.append((Object)"'.");
        Preconditions.checkState((boolean)_isAbsolute, (Object)_builder);
        IWorkspaceRoot _switchResult = null;
        List segments = _segments = path.getSegments();
        boolean _matched = false;
        if (!_matched) {
            boolean _equals;
            int _size = segments.size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                _matched = true;
                _switchResult = this.getWorkspaceRoot();
            }
        }
        if (!_matched) {
            boolean _equals_1;
            int _size_1 = segments.size();
            boolean bl = _equals_1 = _size_1 == 1;
            if (_equals_1) {
                _matched = true;
                IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
                List _segments_1 = path.getSegments();
                String _head = (String)IterableExtensions.head((Iterable)_segments_1);
                _switchResult = _workspaceRoot.getProject(_head);
            }
        }
        if (!_matched) {
            IWorkspaceRoot _workspaceRoot_1 = this.getWorkspaceRoot();
            String _string = path.toString();
            org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
            _switchResult = _workspaceRoot_1.getFolder((IPath)_path);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected IResource findResource(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        return _workspaceRoot.findMember((IPath)_path);
    }

    protected org.eclipse.core.runtime.Path toEclipsePath(Path path) {
        String _string = path.toString();
        return new org.eclipse.core.runtime.Path(_string);
    }

    public Iterable<? extends Path> getChildren(Path path) {
        boolean _not;
        List _xblockexpression = null;
        IContainer container = this.getEclipseContainer(path);
        boolean _exists = container.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            return CollectionLiterals.emptyList();
        }
        List _xtrycatchfinallyexpression = null;
        try {
            IResource[] _members = container.members();
            Functions.Function1<IResource, Path> _function = new Functions.Function1<IResource, Path>(){

                public Path apply(IResource it) {
                    IPath _fullPath = it.getFullPath();
                    String _string = _fullPath.toString();
                    return new Path(_string);
                }
            };
            _xtrycatchfinallyexpression = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_members)), (Functions.Function1)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public boolean exists(Path path) {
        IResource _findResource = this.findResource(path);
        return !Objects.equal((Object)_findResource, null);
    }

    public boolean isFolder(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IContainer;
    }

    public boolean isFile(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IFile;
    }

    public long getLastModification(Path path) {
        long _xblockexpression = 0L;
        IResource resource = this.findResource(path);
        boolean _equals = Objects.equal((Object)resource, null);
        if (_equals) {
            return 0L;
        }
        _xblockexpression = resource.getModificationStamp();
        return _xblockexpression;
    }

    public String getCharset(Path path) {
        try {
            boolean _isFile = this.isFile(path);
            if (_isFile) {
                IFile _eclipseFile = this.getEclipseFile(path);
                return _eclipseFile.getCharset();
            }
            boolean _isFolder = this.isFolder(path);
            if (_isFolder) {
                IContainer _eclipseContainer = this.getEclipseContainer(path);
                return _eclipseContainer.getDefaultCharset();
            }
            Path _parent = path.getParent();
            return this.getCharset(_parent);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public InputStream getContentsAsStream(Path path) {
        InputStream _xtrycatchfinallyexpression = null;
        try {
            IFile _eclipseFile = this.getEclipseFile(path);
            _xtrycatchfinallyexpression = _eclipseFile.getContents();
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public boolean delete(Path path) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IResource _findResource = this.findResource(path);
                _findResource.delete(true, null);
                return true;
            }
            return false;
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean mkdir(Path path) {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _exists = this.exists(path);
        if (_exists) {
            return false;
        }
        Path _parent = path.getParent();
        boolean _exists_1 = this.exists(_parent);
        boolean bl = _not = !_exists_1;
        if (_not) {
            Path _parent_1 = path.getParent();
            this.mkdir(_parent_1);
        }
        boolean _xtrycatchfinallyexpression = false;
        try {
            boolean _xblockexpression_1;
            IContainer _eclipseContainer;
            boolean _switchResult = false;
            IContainer container = _eclipseContainer = this.getEclipseContainer(path);
            boolean _matched = false;
            if (!_matched && container instanceof IFolder) {
                _matched = true;
                _xblockexpression_1 = false;
                ((IFolder)container).create(true, true, null);
                _switchResult = _xblockexpression_1 = true;
            }
            if (!_matched && container instanceof IProject) {
                _matched = true;
                _xblockexpression_1 = false;
                ((IProject)container).create(null);
                _switchResult = _xblockexpression_1 = true;
            }
            if (!_matched) {
                _switchResult = false;
            }
            _xtrycatchfinallyexpression = _switchResult;
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public void setContentsAsStream(Path path, InputStream stream) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IFile _eclipseFile = this.getEclipseFile(path);
                _eclipseFile.setContents(stream, true, true, null);
            } else {
                Path _parent = path.getParent();
                this.mkdir(_parent);
                IFile _eclipseFile_1 = this.getEclipseFile(path);
                _eclipseFile_1.create(stream, true, null);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException exc = (CoreException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public java.net.URI toURI(Path path) {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[0]);
        return this.toURI(path, _newArrayList);
    }

    protected java.net.URI toURI(Path path, List<String> trailingSegments) {
        java.net.URI _xblockexpression = null;
        IResource resource = this.findResource(path);
        boolean _equals = Objects.equal((Object)resource, null);
        if (_equals) {
            String _lastSegment = path.getLastSegment();
            trailingSegments.add(_lastSegment);
            Path _parent = path.getParent();
            return this.toURI(_parent, trailingSegments);
        }
        List _reverse = ListExtensions.reverse(trailingSegments);
        IPath _location = resource.getLocation();
        Functions.Function2<IPath, String, IPath> _function = new Functions.Function2<IPath, String, IPath>(){

            public IPath apply(IPath location, String segment) {
                return location.append(segment);
            }
        };
        IPath _fold = (IPath)IterableExtensions.fold((Iterable)_reverse, (Object)_location, (Functions.Function2)_function);
        _xblockexpression = URIUtil.toURI((IPath)_fold);
        return _xblockexpression;
    }

    public Path getPath(Resource res) {
        boolean _not;
        URI _uRI = res.getURI();
        boolean _isPlatform = _uRI.isPlatform();
        boolean bl = _not = !_isPlatform;
        if (_not) {
            URI _uRI_1 = res.getURI();
            String _plus = "Expecting platform URI but was : " + _uRI_1;
            throw new IllegalStateException(_plus);
        }
        URI _uRI_2 = res.getURI();
        String _platformString = _uRI_2.toPlatformString(false);
        return new Path(_platformString);
    }
}

