/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedExecutableScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithoutReceiver;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescriptionWithSyntacticReceiver;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFeatureScope
extends AbstractSessionBasedExecutableScope {
    private final TypeBucket bucket;
    private final XExpression receiver;
    private final LightweightTypeReference receiverType;

    protected StaticFeatureScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall, XExpression receiver, LightweightTypeReference receiverType, TypeBucket bucket, OperatorMapping operatorMapping) {
        super(parent, session, featureCall, operatorMapping);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.bucket = bucket;
    }

    @Override
    protected List<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        final LinkedHashSet allFeatures = Sets.newLinkedHashSet();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            public void accept(String simpleName, int order) {
                for (JvmType jvmType : StaticFeatureScope.this.bucket.getTypes()) {
                    if (!(jvmType instanceof JvmDeclaredType)) continue;
                    List<JvmFeature> features = StaticFeatureScope.this.findAllFeaturesByName(jvmType, simpleName, StaticFeatureScope.this.bucket.getResolvedFeaturesProvider());
                    if (order == 1) {
                        allFeatures.addAll(features);
                        continue;
                    }
                    int i = 0;
                    int size = features.size();
                    while (i < size) {
                        JvmFeature feature = features.get(i);
                        if (feature.eClass() == TypesPackage.Literals.JVM_OPERATION) {
                            allFeatures.add(feature);
                        }
                        ++i;
                    }
                }
            }
        });
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allDescriptions = Lists.newArrayListWithCapacity((int)allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            this.addDescription(name, feature, allDescriptions);
        }
        return allDescriptions;
    }

    protected void addDescription(QualifiedName name, JvmFeature feature, List<IEObjectDescription> result) {
        if (feature.isStatic()) {
            result.add(this.createDescription(name, feature, this.bucket));
        } else if (this.receiver == null && this.receiverType == null) {
            result.add(this.createInstanceDescription(name, feature, this.bucket));
        }
    }

    protected IEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (this.receiver != null) {
            return new StaticFeatureDescriptionWithSyntacticReceiver(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        if (this.receiverType != null) {
            return new StaticFeatureDescriptionWithImplicitReceiver(name, feature, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new StaticFeatureDescription(name, feature, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    protected IEObjectDescription createInstanceDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        return new InstanceFeatureDescriptionWithoutReceiver(name, feature, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        LinkedHashSet allFeatures = Sets.newLinkedHashSet();
        for (JvmType jvmType : this.bucket.getTypes()) {
            if (!(jvmType instanceof JvmDeclaredType)) continue;
            Iterable features = ((JvmDeclaredType)jvmType).getAllFeatures();
            Iterables.addAll((Collection)allFeatures, (Iterable)features);
        }
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
            this.addDescription(featureName, feature, arrayList);
            QualifiedName operator = this.getOperatorMapping().getOperator(featureName);
            if (operator == null) continue;
            this.addDescription(operator, feature, arrayList);
        }
        return arrayList;
    }

    protected LightweightTypeReference getReceiverType() {
        return this.receiverType;
    }

    protected XExpression getReceiver() {
        return this.receiver;
    }

    protected TypeBucket getBucket() {
        return this.bucket;
    }
}

