/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.mylyn.wikitext.creole.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.creole.internal.block.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.creole.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.creole.internal.block.NowikiBlock;
import org.eclipse.mylyn.wikitext.creole.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.creole.internal.block.TableBlock;
import org.eclipse.mylyn.wikitext.creole.internal.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.wikitext.creole.internal.phrase.NowikiPhraseModifier;
import org.eclipse.mylyn.wikitext.creole.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.creole.internal.token.LinkReplacementToken;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternLineBreakReplacementToken;

public class CreoleLanguage
extends AbstractMarkupLanguage {
    public CreoleLanguage() {
        this.setName("Creole");
    }

    private Block paragraphBreakingBlock(Block block) {
        this.paragraphBreakingBlocks.add(block);
        return block;
    }

    public boolean computeInternalLinkExists(String link) {
        return true;
    }

    public String toInternalHref(String pageName) {
        String pageId = pageName.replace(' ', '_');
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(this.paragraphBreakingBlock(new ListBlock()));
        blocks.add(this.paragraphBreakingBlock(new HorizontalRuleBlock()));
        blocks.add(this.paragraphBreakingBlock(new HeadingBlock()));
        blocks.add(this.paragraphBreakingBlock(new NowikiBlock()));
        blocks.add(this.paragraphBreakingBlock(new TableBlock()));
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new NowikiPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("**", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("//", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("##", DocumentBuilder.SpanType.MONOSPACE, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^^", DocumentBuilder.SpanType.SUPERSCRIPT, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier(",,", DocumentBuilder.SpanType.SUBSCRIPT, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", DocumentBuilder.SpanType.UNDERLINED, true));
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\\\\\\\)"));
        tokenSyntax.add((PatternBasedElement)new LinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }
}

