/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class ObjectUtils {
    private static final Random RANDOM = new Random();

    private ObjectUtils() {
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterator) {
        ArrayList collection = new ArrayList();
        return ObjectUtils.addToCollection(iterator, collection);
    }

    public static <T> List<T> asList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static int[] asIntArray(Collection<Integer> collection) {
        int[] copy = new int[collection.size()];
        int index = 0;
        for (Integer value : collection) {
            copy[index] = value;
            ++index;
        }
        return copy;
    }

    public static <T> Collection<T> asOrderedCollection(Iterator<T> iterator, Comparator<T> comparator) {
        TreeSet<T> collection = new TreeSet<T>(comparator);
        return ObjectUtils.addToCollection(iterator, collection);
    }

    private static <T> Collection<T> addToCollection(Iterator<T> iterator, Collection<T> collection) {
        while (iterator.hasNext()) {
            T object = iterator.next();
            collection.add(object);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> String toString(Collection<T> collection) {
        if (collection == null) {
            return "NULL";
        }
        Object out = "[ ";
        int count = 1;
        for (T object : collection) {
            if (object == null) continue;
            out = (String)out + object.toString();
            if (collection.size() != count) {
                out = (String)out + ";\n";
            }
            ++count;
        }
        out = (String)out + " ]";
        return out;
    }

    public static <T> String toString(T[] array) {
        return ObjectUtils.toString(Arrays.asList(array));
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !ObjectUtils.isEmpty(collection);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static Date getRandomDate() {
        return new Date(RANDOM.nextLong());
    }

    public static int getRandomNumber() {
        return RANDOM.nextInt(10000);
    }

    public static int getRandomNumber(int max) {
        return RANDOM.nextInt(max);
    }

    public static <T> T getLastElement(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T getFirstElement(List<T> list) {
        return list.get(0);
    }

    public static boolean collectionsEqual(Collection c1, Collection c2) {
        if (c1 != null && c2 != null) {
            HashSet hc1 = new HashSet(c1);
            HashSet hc2 = new HashSet(c2);
            if (hc1.size() == hc2.size()) {
                if (!hc1.equals(hc2)) {
                    for (Object f1 : hc1) {
                        if (hc2.contains(f1)) continue;
                        return false;
                    }
                    for (Object f2 : hc2) {
                        if (hc1.contains(f2)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

