/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class CreateMethodAccessAdapter
extends AbstractTransformableClassNode {
    private Method method;
    private int accessId;
    private Method access;
    private int firstArgIndex;
    private boolean isConstructor;

    public CreateMethodAccessAdapter(Method method, int accessId) {
        this.method = method;
        this.accessId = accessId;
        this.isConstructor = method.getName().equals("<init>");
        if (method.isStatic() || this.isConstructor) {
            this.access = ConstantMembers.accessStatic;
            this.firstArgIndex = 0;
        } else {
            this.access = ConstantMembers.access;
            this.firstArgIndex = 1;
        }
    }

    @Override
    public boolean transform() {
        String desc = this.method.getSignature();
        InsnList instructions = new InsnList();
        if (this.isConstructor) {
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, this.name));
            instructions.add((AbstractInsnNode)new InsnNode(89));
        } else if (!this.method.isStatic()) {
            instructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
        }
        Type[] args = Type.getArgumentTypes((String)desc);
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                instructions.add((AbstractInsnNode)new IntInsnNode(25, this.firstArgIndex + 2));
                instructions.add(this.createLoadIntConstant(i));
                instructions.add((AbstractInsnNode)new InsnNode(50));
                Type arg = args[i];
                if (arg.getSort() != 9 && arg.getSort() != 10) {
                    String objectType = AsmTypeHelper.getObjectType(arg);
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                    instructions.add(AsmTypeHelper.getUnboxingInstructionForType(arg, objectType));
                } else {
                    instructions.add((AbstractInsnNode)new TypeInsnNode(192, arg.getInternalName()));
                }
                ++i;
            }
        }
        int opcode = 182;
        if (this.method.isStatic()) {
            opcode = 184;
        } else if (this.isConstructor) {
            opcode = 183;
        }
        instructions.add((AbstractInsnNode)new MethodInsnNode(opcode, this.name, this.method.getName(), this.method.getSignature(), false));
        Type returnType = Type.getReturnType((String)desc);
        if (returnType.getSort() != 10 && returnType.getSort() != 9 && returnType.getSort() != 0) {
            instructions.add(AsmTypeHelper.getBoxingInstructionForType(returnType));
            instructions.add((AbstractInsnNode)new InsnNode(176));
        } else if (returnType.getSort() == 0 && !this.isConstructor) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new InsnNode(176));
        } else {
            instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        MethodNode access = this.getMethod(this.access);
        this.addNewLabelToSwitch(access.instructions, instructions, this.accessId);
        return true;
    }
}

