/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.presentation.sync;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ProjectConfigPlugin;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorPlugin;
import org.eclipse.oomph.projectconfig.presentation.sync.ProjectConfigSynchronizerDialog;
import org.eclipse.oomph.projectconfig.presentation.sync.ProjectConfigSynchronizerPreferences;
import org.eclipse.oomph.projectconfig.util.ProjectConfigUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ProjectConfigSynchronizer
implements IStartup {
    private static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();
    private static final IWorkspaceRoot WORKSPACE_ROOT = WORKSPACE.getRoot();
    private WorkspaceConfiguration workspaceConfiguration;
    private ProjectConfigSynchronizerDialog projectConfigSynchronizerDialog;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        private Collection<IPath> changedPaths = new HashSet<IPath>();

                        ResourceDeltaVisitor() {
                        }

                        public Collection<IPath> getChangedPaths() {
                            return this.changedPaths;
                        }

                        public boolean visit(IResourceDelta delta) {
                            int type = delta.getResource().getType();
                            if (type == 2) {
                                IPath fullPath = delta.getFullPath();
                                if (!".settings".equals(fullPath.lastSegment())) {
                                    return false;
                                }
                            } else if (type == 1) {
                                IPath fullPath = delta.getFullPath();
                                if (fullPath.segmentCount() > 2 && "prefs".equals(fullPath.getFileExtension()) && !"org.eclipse.oomph.projectconfig".equals(fullPath.removeFileExtension().lastSegment())) {
                                    this.changedPaths.add(fullPath);
                                }
                                return false;
                            }
                            return true;
                        }
                    }
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                    final Collection<IPath> changedPaths = visitor.getChangedPaths();
                    if (!changedPaths.isEmpty()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                final WorkspaceConfiguration newWorkspaceConfiguration = ProjectConfigUtil.getWorkspaceConfiguration();
                                try {
                                    newWorkspaceConfiguration.updatePreferenceProfileReferences();
                                    Resource newWorkspaceConfigurationResource = newWorkspaceConfiguration.eResource();
                                    LinkedHashMap<Property, Property> propertyMap = new LinkedHashMap<Property, Property>();
                                    for (IPath preferenceNodePath : changedPaths) {
                                        String projectName = preferenceNodePath.segment(0);
                                        Project oldProject = ProjectConfigSynchronizer.this.workspaceConfiguration.getProject(projectName);
                                        Project project = newWorkspaceConfiguration.getProject(projectName);
                                        if (project == null) continue;
                                        String preferenceNodeName = preferenceNodePath.removeFileExtension().lastSegment();
                                        PreferenceNode oldPreferenceNode = oldProject == null ? null : oldProject.getPreferenceNode().getNode(preferenceNodeName);
                                        PreferenceNode newPreferenceNode = project.getPreferenceNode().getNode(preferenceNodeName);
                                        Map<Property, Property> modifiedProperties = this.collectModifiedProperties(ProjectConfigSynchronizer.this.workspaceConfiguration, oldPreferenceNode, newPreferenceNode);
                                        if (modifiedProperties.isEmpty()) continue;
                                        for (Map.Entry<Property, Property> entry : modifiedProperties.entrySet()) {
                                            Property property = entry.getKey();
                                            String value = property.getValue();
                                            Property preferenceProfileProperty = project.getProperty(property.getRelativePath());
                                            if (preferenceProfileProperty != null) {
                                                String preferenceProfilePropertyValue = preferenceProfileProperty.getValue();
                                                if (!(value == null ? preferenceProfilePropertyValue != null : !value.equals(preferenceProfilePropertyValue))) continue;
                                                propertyMap.put(property, preferenceProfileProperty);
                                                continue;
                                            }
                                            propertyMap.put(property, entry.getValue());
                                        }
                                    }
                                    if (!propertyMap.isEmpty()) {
                                        boolean dialogCreator = false;
                                        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                        Shell shell = activeWorkbenchWindow.getShell();
                                        if (ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog == null && (ProjectConfigSynchronizer.this.configurationValidationPrompt || ProjectConfigSynchronizer.this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROMPT)) {
                                            ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog = new ProjectConfigSynchronizerDialog(shell);
                                            ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.setWorkspaceConfiguration(newWorkspaceConfiguration);
                                            dialogCreator = true;
                                        }
                                        HashMap<Property, Property> managedProperties = new HashMap<Property, Property>();
                                        for (Map.Entry entry : propertyMap.entrySet()) {
                                            Property property = (Property)entry.getKey();
                                            Property otherProperty = (Property)entry.getValue();
                                            if (otherProperty != null && otherProperty.eResource() == newWorkspaceConfigurationResource) {
                                                if (ProjectConfigSynchronizer.this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROMPT) {
                                                    ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.managedProperty(property, otherProperty);
                                                }
                                                managedProperties.put(property, otherProperty);
                                                continue;
                                            }
                                            if (!ProjectConfigSynchronizer.this.configurationValidationPrompt) continue;
                                            ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.unmanagedProperty(property, otherProperty);
                                        }
                                        if (ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog != null) {
                                            if (dialogCreator) {
                                                ProjectConfigSynchronizerDialog projectConfigSynchronizerDialog = ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog;
                                                ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.open();
                                                if (projectConfigSynchronizerDialog.hasUnmanagedProperties() && ProjectConfigSynchronizerPreferences.isEdit()) {
                                                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.oomph.projectconfig.presentation.ProjectConfigPreferencePage", null, null);
                                                    preferenceDialog.open();
                                                }
                                            } else {
                                                Shell shell2 = ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.getShell();
                                                Display display = shell2.getDisplay();
                                                while (!shell2.isDisposed()) {
                                                    if (display.readAndDispatch()) continue;
                                                    display.sleep();
                                                }
                                            }
                                        }
                                        if (!managedProperties.isEmpty() && (ProjectConfigSynchronizer.this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROPAGATE || ProjectConfigSynchronizer.this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROMPT && ProjectConfigSynchronizerPreferences.isPropagate())) {
                                            for (Map.Entry entry : managedProperties.entrySet()) {
                                                Property managedProperty = (Property)entry.getKey();
                                                Property managingProperty = (Property)entry.getValue();
                                                try {
                                                    Preferences preferences = org.eclipse.oomph.preferences.util.PreferencesUtil.getPreferences((PreferenceNode)managingProperty.getParent(), (boolean)false);
                                                    preferences.put(managingProperty.getName(), managedProperty.getValue());
                                                }
                                                catch (BackingStoreException ex) {
                                                    ProjectConfigEditorPlugin.INSTANCE.log((Object)ex);
                                                }
                                            }
                                            try {
                                                WORKSPACE_ROOT.getWorkspace().run(new IWorkspaceRunnable(){

                                                    public void run(IProgressMonitor monitor) throws CoreException {
                                                        try {
                                                            org.eclipse.oomph.preferences.util.PreferencesUtil.getPreferences((PreferenceNode)newWorkspaceConfiguration.getInstancePreferenceNode().getParent().getNode("project"), (boolean)false).flush();
                                                        }
                                                        catch (BackingStoreException ex) {
                                                            ProjectConfigPlugin.INSTANCE.log((Object)ex);
                                                        }
                                                    }
                                                }, (IProgressMonitor)new NullProgressMonitor());
                                            }
                                            catch (CoreException coreException) {
                                                ProjectConfigPlugin.INSTANCE.log((Object)coreException);
                                            }
                                        }
                                    }
                                    if (ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog == null || !ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog.hasManagedProperties()) {
                                        newWorkspaceConfiguration.applyPreferenceProfiles();
                                    }
                                }
                                finally {
                                    ProjectConfigSynchronizer.this.workspaceConfiguration = newWorkspaceConfiguration;
                                    ProjectConfigSynchronizer.this.projectConfigSynchronizerDialog = null;
                                }
                            }

                            private Map<Property, Property> collectModifiedProperties(WorkspaceConfiguration workspaceConfiguration, PreferenceNode oldPreferenceNode, PreferenceNode newPreferenceNode) {
                                LinkedHashMap<Property, Property> result = new LinkedHashMap<Property, Property>();
                                this.collectModifiedProperties(result, workspaceConfiguration, oldPreferenceNode, newPreferenceNode);
                                return result;
                            }

                            private void collectModifiedProperties(Map<Property, Property> result, WorkspaceConfiguration workspaceConfiguration, PreferenceNode oldPreferenceNode, PreferenceNode newPreferenceNode) {
                                for (PreferenceNode newChild : newPreferenceNode.getChildren()) {
                                    PreferenceNode oldChild;
                                    PreferenceNode preferenceNode = oldChild = oldPreferenceNode == null ? null : oldPreferenceNode.getNode(newChild.getName());
                                    if (oldChild == null) {
                                        for (Property newProperty : newChild.getProperties()) {
                                            result.put(newProperty, null);
                                        }
                                        continue;
                                    }
                                    this.collectModifiedProperties(result, workspaceConfiguration, oldChild, newChild);
                                }
                                for (Property newProperty : newPreferenceNode.getProperties()) {
                                    Property oldProperty;
                                    Property property = oldProperty = oldPreferenceNode == null ? null : oldPreferenceNode.getProperty(newProperty.getName());
                                    if (oldProperty == null) {
                                        result.put(newProperty, null);
                                        continue;
                                    }
                                    String newValue = newProperty.getValue();
                                    String oldValue = oldProperty.getValue();
                                    if (!(newValue == null ? oldValue != null : !newValue.equals(oldValue))) continue;
                                    result.put(newProperty, oldProperty);
                                }
                            }
                        });
                    }
                }
                catch (CoreException exception) {
                    ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    };
    private boolean configurationValidationPrompt = ProjectConfigSynchronizerPreferences.isConfigurationValidationPrompt();
    private ProjectConfigSynchronizerPreferences.PropertyModificationHandling propertyModificationHandling = ProjectConfigSynchronizerPreferences.getPropertyModificationHandling();

    public ProjectConfigSynchronizer() {
        ProjectConfigEditorPlugin.Implementation.setProjectConfigSynchronizer(this);
    }

    public void earlyStartup() {
        this.update();
    }

    public void stop() {
        WORKSPACE.removeResourceChangeListener(this.resourceChangeListener);
    }

    public void update() {
        if (ProjectConfigSynchronizerPreferences.isConfigurationManagementAutomatic()) {
            new ProjectConfigUtil.CompletenessChecker(){

                protected void complete(WorkspaceConfiguration workspaceConfiguration) {
                    ProjectConfigSynchronizer.this.workspaceConfiguration = workspaceConfiguration;
                    workspaceConfiguration.updatePreferenceProfileReferences();
                }
            };
            WORKSPACE.addResourceChangeListener(this.resourceChangeListener);
        } else {
            WORKSPACE.removeResourceChangeListener(this.resourceChangeListener);
        }
        this.configurationValidationPrompt = ProjectConfigSynchronizerPreferences.isConfigurationValidationPrompt();
        this.propertyModificationHandling = ProjectConfigSynchronizerPreferences.getPropertyModificationHandling();
    }
}

