/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.maven.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.oomph.resources.MavenProjectFactory;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.maven.MavenImportTask;
import org.eclipse.oomph.setup.maven.MavenPackage;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImportTaskImpl
extends SetupTaskImpl
implements MavenImportTask {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected EList<SourceLocator> sourceLocators;
    protected static final String PROJECT_NAME_TEMPLATE_EDEFAULT = null;
    protected String projectNameTemplate = PROJECT_NAME_TEMPLATE_EDEFAULT;

    protected MavenImportTaskImpl() {
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.MAVEN_IMPORT_TASK;
    }

    @Override
    public EList<SourceLocator> getSourceLocators() {
        if (this.sourceLocators == null) {
            this.sourceLocators = new EObjectContainmentEList(SourceLocator.class, (InternalEObject)this, 9);
        }
        return this.sourceLocators;
    }

    @Override
    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    @Override
    public void setProjectNameTemplate(String newProjectNameTemplate) {
        String oldProjectNameTemplate = this.projectNameTemplate;
        this.projectNameTemplate = newProjectNameTemplate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldProjectNameTemplate, (Object)this.projectNameTemplate));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getSourceLocators()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getSourceLocators();
            }
            case 10: {
                return this.getProjectNameTemplate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getSourceLocators().clear();
                this.getSourceLocators().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setProjectNameTemplate((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getSourceLocators().clear();
                return;
            }
            case 10: {
                this.setProjectNameTemplate(PROJECT_NAME_TEMPLATE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.sourceLocators != null && !this.sourceLocators.isEmpty();
            }
            case 10: {
                return PROJECT_NAME_TEMPLATE_EDEFAULT == null ? this.projectNameTemplate != null : !PROJECT_NAME_TEMPLATE_EDEFAULT.equals(this.projectNameTemplate);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (projectNameTemplate: ");
        result.append(this.projectNameTemplate);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        EList<SourceLocator> sourceLocators = this.getSourceLocators();
        if (sourceLocators.isEmpty()) {
            return false;
        }
        if (context.getTrigger() != Trigger.MANUAL) {
            IProject[] iProjectArray = ROOT.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IPath projectFolder = project.getLocation();
                for (SourceLocator sourceLocator : sourceLocators) {
                    Path rootFolder = new Path(sourceLocator.getRootFolder());
                    if (!rootFolder.isPrefixOf(projectFolder)) continue;
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void perform(SetupTaskContext context) throws Exception {
        MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
        ProgressLogMonitor monitor = new ProgressLogMonitor((ProgressLog)context);
        LinkedHashSet<MavenProjectInfo> projectInfos = new LinkedHashSet<MavenProjectInfo>();
        for (SourceLocator sourceLocator : this.getSourceLocators()) {
            LocalProjectScanner projectScanner = new LocalProjectScanner(null, Collections.singletonList(sourceLocator.getRootFolder()), false, modelManager);
            projectScanner.run((IProgressMonitor)monitor);
            for (MavenProjectInfo projectInfo : projectScanner.getProjects()) {
                MavenImportTaskImpl.processMavenProject(projectInfo, projectInfos, sourceLocator, (IProgressMonitor)monitor);
            }
        }
        if (!projectInfos.isEmpty()) {
            IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
            ProjectImportConfiguration projectImportConfiguration = new ProjectImportConfiguration();
            String projectNameTemplate = this.getProjectNameTemplate();
            if (!StringUtil.isEmpty((String)projectNameTemplate)) {
                projectImportConfiguration.setProjectNameTemplate(projectNameTemplate);
            }
            projectConfigurationManager.importProjects(projectInfos, projectImportConfiguration, (IProgressMonitor)monitor);
        }
    }

    private static void processMavenProject(MavenProjectInfo projectInfo, Set<MavenProjectInfo> projectInfos, SourceLocator sourceLocator, IProgressMonitor monitor) {
        String projectName;
        String projectFolder = projectInfo.getPomFile().getParent();
        BackendContainer backendContainer = (BackendContainer)BackendResource.get((String)projectFolder);
        IProject project = sourceLocator.loadProject(MavenProjectFactory.LIST, backendContainer, monitor);
        if (project != null && sourceLocator.matches(project) && !ROOT.getProject(projectName = project.getName()).exists()) {
            projectInfos.add(projectInfo);
        }
        for (MavenProjectInfo childProjectInfo : projectInfo.getProjects()) {
            MavenImportTaskImpl.processMavenProject(childProjectInfo, projectInfos, sourceLocator, monitor);
        }
    }
}

