/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;

public class CategoryElement
extends RemoteQueriedElement
implements IIUElement {
    private ArrayList<IInstallableUnit> ius = new ArrayList(1);
    private Collection<IRequirement> requirements;
    private Object[] cache = null;

    public CategoryElement(Object parent, IInstallableUnit iu) {
        super(parent);
        this.ius.add(iu);
    }

    @Override
    protected String getImageId(Object obj) {
        return "obj/category_obj.gif";
    }

    @Override
    public String getLabel(Object o) {
        IInstallableUnit iu = this.getIU();
        if (iu != null) {
            return iu.getId();
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IInstallableUnit.class) {
            return this.getIU();
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected int getDefaultQueryType() {
        return 4;
    }

    @Override
    public IInstallableUnit getIU() {
        if (this.ius == null || this.ius.isEmpty()) {
            return null;
        }
        return this.ius.get(0);
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public boolean shouldShowSize() {
        return false;
    }

    @Override
    public void computeSize(IProgressMonitor monitor) {
    }

    @Override
    public boolean shouldShowVersion() {
        return false;
    }

    public void mergeIU(IInstallableUnit iu) {
        this.ius.add(iu);
    }

    public boolean shouldMerge(IInstallableUnit iu) {
        IInstallableUnit myIU = this.getIU();
        if (myIU == null) {
            return false;
        }
        return this.getMergeKey(myIU).equals(this.getMergeKey(iu));
    }

    private String getMergeKey(IInstallableUnit iu) {
        String mergeKey = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (mergeKey == null || mergeKey.length() == 0) {
            mergeKey = iu.getId();
        }
        return mergeKey;
    }

    @Override
    public Collection<IRequirement> getRequirements() {
        if (this.ius == null || this.ius.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.requirements == null) {
            if (this.ius.size() == 1) {
                this.requirements = this.getIU().getRequirements();
            } else {
                ArrayList<IRequirement> capabilities = new ArrayList<IRequirement>();
                for (IInstallableUnit iu : this.ius) {
                    capabilities.addAll(iu.getRequirements());
                }
                this.requirements = capabilities;
            }
        }
        return this.requirements;
    }

    @Override
    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) {
        if (this.cache == null) {
            this.cache = super.fetchChildren(o, monitor);
        }
        return this.cache;
    }

    @Override
    public boolean shouldShowChildren() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryElement)) {
            return false;
        }
        IInstallableUnit myIU = this.getIU();
        IInstallableUnit objIU = ((CategoryElement)obj).getIU();
        if (myIU == null || objIU == null) {
            return false;
        }
        return this.getMergeKey(myIU).equals(this.getMergeKey(objIU));
    }

    public int hashCode() {
        IInstallableUnit iu = this.getIU();
        int result = 1;
        result = 23 * result + (iu == null ? 0 : this.getMergeKey(iu).hashCode());
        return result;
    }

    public String toString() {
        IInstallableUnit iu = this.getIU();
        if (iu == null) {
            return "NULL";
        }
        StringBuffer result = new StringBuffer();
        result.append("Category Element - ");
        result.append(this.getMergeKey(iu));
        result.append(" (merging IUs: ");
        result.append(this.ius.toString());
        result.append(")");
        return result.toString();
    }
}

