/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.SashLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SashRenderer
extends SWTPartRenderer {
    @Inject
    private IEventBroker eventBroker;
    private static final int UNDEFINED_WEIGHT = -1;
    private static final int DEFAULT_WEIGHT = 5000;
    private EventHandler sashOrientationHandler;
    private EventHandler sashWeightHandler;
    private int processedContent = 0;

    @PostConstruct
    void postConstruct() {
        this.sashOrientationHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (element.getRenderer() != SashRenderer.this) {
                    return;
                }
                SashRenderer.this.forceLayout((MElementContainer<MUIElement>)((MElementContainer)element));
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/GenericTile/horizontal/*", this.sashOrientationHandler);
        this.sashWeightHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                MElementContainer parent = element.getParent();
                if (parent.getRenderer() != SashRenderer.this) {
                    return;
                }
                SashRenderer.this.forceLayout((MElementContainer<MUIElement>)parent);
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/containerData/*", this.sashWeightHandler);
    }

    /*
     * Unable to fully structure code
     */
    protected void forceLayout(MElementContainer<MUIElement> pscModel) {
        if (this.processedContent == 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            pscModel = pscModel.getParent();
lbl4:
            // 2 sources

            ** while (!(pscModel.getWidget() instanceof Composite))
        }
lbl5:
        // 1 sources

        s = (Composite)pscModel.getWidget();
        layout = s.getLayout();
        if (layout instanceof SashLayout && ((SashLayout)layout).layoutUpdateInProgress) {
            return;
        }
        s.layout(true, true);
    }

    @PreDestroy
    void preDestroy() {
        this.eventBroker.unsubscribe(this.sashOrientationHandler);
        this.eventBroker.unsubscribe(this.sashWeightHandler);
    }

    public Object createWidget(final MUIElement element, Object parent) {
        MElementContainer elementParent = element.getParent();
        if (elementParent == null && element.getCurSharedRef() != null) {
            elementParent = element.getCurSharedRef();
        }
        if (elementParent != null && elementParent.getRenderer() == this) {
            Rectangle newRect = new Rectangle(0, 0, 0, 0);
            if (parent instanceof Composite) {
                ((Composite)parent).addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        element.setWidget(null);
                        element.setRenderer(null);
                    }
                });
            }
            return newRect;
        }
        Composite sashComposite = null;
        MPartSashContainer psc = (MPartSashContainer)element;
        for (MPartSashContainerElement psce : psc.getChildren()) {
            if (!(psce instanceof MPartSashContainer) || !(psce.getWidget() instanceof Composite)) continue;
            sashComposite = (Composite)psce.getWidget();
            this.bindWidget((MUIElement)psce, new Rectangle(0, 0, 0, 0));
        }
        if (sashComposite == null) {
            sashComposite = new Composite((Composite)parent, 0);
        }
        sashComposite.setLayout((Layout)new SashLayout(sashComposite, element));
        return sashComposite;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        int weight = SashRenderer.getWeight(element);
        if (weight == -1) {
            element.setContainerData(Integer.toString(5000));
        }
        this.forceLayout(parentElement);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        try {
            ++this.processedContent;
            super.processContents(container);
        }
        finally {
            --this.processedContent;
            if (this.processedContent == 0) {
                this.forceLayout(container);
            }
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        this.forceLayout(parentElement);
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parentElement = element.getParent();
        while (parentElement.getRenderer() == this && !(parentElement.getWidget() instanceof Composite)) {
            parentElement = parentElement.getParent();
        }
        if (parentElement.getWidget() instanceof Composite) {
            return parentElement.getWidget();
        }
        return null;
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            element.setContainerData(Integer.toString(10000));
            info = element.getContainerData();
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

