/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import org.eclipse.oomph.util.StringUtil;

public final class LicenseInfo {
    private static final String SEPARATOR = " ";
    private final String uuid;
    private final String name;

    public LicenseInfo(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        int pos = string.indexOf(SEPARATOR);
        if (pos != -1) {
            this.uuid = string.substring(0, pos);
            this.name = string.substring(pos + 1).trim();
        } else {
            this.uuid = string;
            this.name = null;
        }
    }

    public LicenseInfo(String uuid, String name) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid is null");
        }
        this.uuid = uuid;
        this.name = name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (!StringUtil.isEmpty((String)this.name)) {
            return this.name;
        }
        return this.uuid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LicenseInfo other = (LicenseInfo)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        String string = this.uuid;
        if (!StringUtil.isEmpty((String)this.name)) {
            string = String.valueOf(string) + SEPARATOR + this.name;
        }
        return string;
    }

    public static String getFirstLine(String body) {
        int i = body.indexOf(10);
        int j = body.indexOf(13);
        if (i > 0) {
            if (j > 0) {
                return body.substring(0, i < j ? i : j);
            }
            return body.substring(0, i);
        }
        if (j > 0) {
            return body.substring(0, j);
        }
        return body;
    }
}

