/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileLock;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.oomph.p2.internal.core.LazyProfile;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyProfileRegistry
extends SimpleProfileRegistry {
    private static final String PROFILE_EXT = ".profile";
    private static final String PROFILE_GZ_EXT = ".profile.gz";
    private final IProvisioningAgent provisioningAgent;
    private final File store;
    private final String self;
    private boolean updateSelfProfile;
    private final Map<String, ProfileLock> profileLocks;
    private Map<String, Profile> profileMap;

    public LazyProfileRegistry(IProvisioningAgent provisioningAgent, File store) {
        super(provisioningAgent, store);
        this.provisioningAgent = provisioningAgent;
        this.store = store;
        Field selfField = ReflectUtil.getField(SimpleProfileRegistry.class, (String)"self");
        this.self = (String)ReflectUtil.getValue((Field)selfField, (Object)((Object)this));
        Field updateSelfProfileField = ReflectUtil.getField(SimpleProfileRegistry.class, (String)"updateSelfProfile");
        this.updateSelfProfile = (Boolean)ReflectUtil.getValue((Field)updateSelfProfileField, (Object)((Object)this));
        Field profileLocksField = ReflectUtil.getField(SimpleProfileRegistry.class, (String)"profileLocks");
        this.profileLocks = (Map)ReflectUtil.getValue((Field)profileLocksField, (Object)((Object)this));
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    public synchronized void resetProfiles() {
        this.profileMap = null;
    }

    public synchronized void removeProfile(String id, long timestamp) throws ProvisionException {
        IProfile profile;
        LazyProfile lazyProfile;
        Profile p;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((p = this.getProfileMap().get(id)) instanceof LazyProfile && (lazyProfile = (LazyProfile)p).getDelegate(false) != null && (profile = this.getProfile(id)) != null && profile.getTimestamp() == timestamp) {
            throw new ProvisionException("Cannot remove the current profile timestamp");
        }
        super.removeProfile(id, timestamp);
    }

    public synchronized boolean containsProfile(String id) {
        LazyProfile lazyProfile;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (id == null) {
            return false;
        }
        Profile p = this.getProfileMap().get(id);
        if (p instanceof LazyProfile && (lazyProfile = (LazyProfile)p).getDelegate(false) != null && this.getProfile(id) != null) {
            return true;
        }
        return super.containsProfile(id);
    }

    protected final synchronized Map<String, Profile> getProfileMap() {
        if (this.profileMap == null) {
            File[] profileDirectories;
            if (this.store == null || !this.store.isDirectory()) {
                throw new IllegalStateException(NLS.bind((String)"Registry Directory not available: {0}.", (Object)this.store));
            }
            this.profileMap = new HashMap<String, Profile>();
            File[] fileArray = profileDirectories = this.store.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(LazyProfileRegistry.PROFILE_EXT) && pathname.isDirectory();
                }
            });
            int n = profileDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File profileDirectory = fileArray[n2];
                File profileFile = LazyProfileRegistry.findLatestProfileFile(profileDirectory);
                if (profileFile == null) {
                    IOUtil.deleteBestEffort((File)profileFile);
                } else {
                    String directoryName = profileDirectory.getName();
                    String profileId = LazyProfileRegistry.unescape((String)directoryName.substring(0, directoryName.lastIndexOf(PROFILE_EXT)));
                    LazyProfile profile = new LazyProfile(this, profileId, profileDirectory);
                    this.profileMap.put(profileId, profile);
                }
                ++n2;
            }
        }
        if (this.updateSelfProfile) {
            Method updateSelfProfileMethod = ReflectUtil.getMethod(SimpleProfileRegistry.class, (String)"updateSelfProfile", (Class[])new Class[]{Map.class});
            ReflectUtil.invokeMethod((Method)updateSelfProfileMethod, (Object)((Object)this), (Object[])new Object[]{this.profileMap});
            this.updateSelfProfile = false;
        }
        return this.profileMap;
    }

    /*
     * Unable to fully structure code
     */
    public Profile loadProfile(String profileId, File profileDirectory) {
        if (this.store == null || !this.store.isDirectory()) {
            throw new IllegalStateException(NLS.bind((String)"Registry Directory not available: {0}.", (Object)this.store));
        }
        try {
            parserClass = CommonPlugin.loadClass((String)"org.eclipse.equinox.p2.engine", (String)"org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry$Parser");
            constructor = ReflectUtil.getConstructor((Class)parserClass, (Class[])new Class[]{SimpleProfileRegistry.class, BundleContext.class, String.class});
            parseMethod = ReflectUtil.getMethod((Class)parserClass, (String)"parse", (Class[])new Class[]{File.class});
            getProfileMapMethod = ReflectUtil.getMethod((Class)parserClass, (String)"getProfileMap", (Class[])new Class[0]);
            addProfilePlaceHolderMethod = ReflectUtil.getMethod((Class)parserClass, (String)"addProfilePlaceHolder", (Class[])new Class[]{String.class});
            parser = ReflectUtil.newInstance((Constructor)constructor, (Object[])new Object[]{this, EngineActivator.getContext(), "org.eclipse.equinox.p2.engine"});
            lock = this.profileLocks.get(profileId);
            if (lock == null) {
                lock = new ProfileLock((Object)this, profileDirectory);
                this.profileLocks.put(profileId, lock);
            }
            locked = false;
            if (lock.processHoldsLock() || (locked = lock.lock())) {
                try {
                    profileFile = LazyProfileRegistry.findLatestProfileFile(profileDirectory);
                    if (profileFile == null) ** GOTO lbl29
                    ReflectUtil.invokeMethod((Method)parseMethod, (Object)parser, (Object[])new Object[]{profileFile});
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            } else {
                ReflectUtil.invokeMethod((Method)addProfilePlaceHolderMethod, (Object)parser, (Object[])new Object[]{profileId});
            }
lbl29:
            // 3 sources

            profileMap = (Map)ReflectUtil.invokeMethod((Method)getProfileMapMethod, (Object)parser, (Object[])new Object[0]);
            return (Profile)profileMap.get(profileId);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File findLatestProfileFile(File profileDirectory) {
        File latest = null;
        long latestTimestamp = 0L;
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return (pathname.getName().endsWith(LazyProfileRegistry.PROFILE_GZ_EXT) || pathname.getName().endsWith(LazyProfileRegistry.PROFILE_EXT)) && !pathname.isDirectory();
            }
        });
        if (profileFiles == null) {
            return null;
        }
        int i = 0;
        while (i < profileFiles.length) {
            File profileFile = profileFiles[i];
            String fileName = profileFile.getName();
            try {
                long timestamp = Long.parseLong(fileName.substring(0, fileName.indexOf(PROFILE_EXT)));
                if (timestamp > latestTimestamp) {
                    latestTimestamp = timestamp;
                    latest = profileFile;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return latest;
    }
}

