/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.provider;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.oomph.base.util.EAnnotations;

public final class BaseEditUtil {
    private static final String TASK_SUFFIX = " Task";

    private BaseEditUtil() {
    }

    public static IconReflectiveItemProvider replaceReflectiveItemProvider(ComposedAdapterFactory adapterFactory) {
        EClass dynamicClass = EcoreFactory.eINSTANCE.createEClass();
        dynamicClass.setName("Dynamic");
        EPackage dynamicPackage = EcoreFactory.eINSTANCE.createEPackage();
        dynamicPackage.setName("dynamic");
        dynamicPackage.setNsPrefix("dynamic");
        dynamicPackage.setNsURI("http://dynamic");
        dynamicPackage.getEClassifiers().add((Object)dynamicClass);
        AdapterFactory factory = adapterFactory.getFactoryForType((Object)EcoreUtil.create((EClass)dynamicClass));
        if (factory != null) {
            adapterFactory.removeAdapterFactory(factory);
        }
        IconReflectiveItemProvider[] itemProvider = new IconReflectiveItemProvider[1];
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory(itemProvider){
            {
                iconReflectiveItemProviderArray[0] = new IconReflectiveItemProvider((AdapterFactory)this);
                this.reflectiveItemProviderAdapter = iconReflectiveItemProviderArray[0];
            }
        });
        return itemProvider[0];
    }

    public static ComposedAdapterFactory createAdapterFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BaseEditUtil.replaceReflectiveItemProvider(adapterFactory);
        return adapterFactory;
    }

    public static Object getImage(URI uri) {
        return RemoteImage.create(uri);
    }

    public static final class IconReflectiveItemProvider
    extends ReflectiveItemProvider {
        public IconReflectiveItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getTypeText(Object object) {
            String typeText = super.getTypeText(object);
            if (typeText.endsWith(BaseEditUtil.TASK_SUFFIX)) {
                typeText = typeText.substring(0, typeText.length() - BaseEditUtil.TASK_SUFFIX.length());
            }
            return typeText;
        }

        public Object getImage(Object object) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            URI imageURI = EAnnotations.getImageURI((EClass)eClass);
            if (imageURI != null) {
                return BaseEditUtil.getImage(imageURI);
            }
            return super.getImage(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoteImage
    extends ComposedImage {
        private static final URIConverter URI_CONVERTER;
        private static final Map<?, ?> OPTIONS;
        private static final Constructor<?> IMAGE_DATA_CONSTRUCTOR;
        private static final Method IMAGE_DESCRIPTOR_CREATE_FROM_IMAGE_DATA_METHOD;

        static {
            URIConverter uriConverter = null;
            Map options = null;
            Constructor imageDataConstructor = null;
            Method imageDescriptorCreateFromImageDataMethod = null;
            try {
                Class setupCoreUtilClass = CommonPlugin.loadClass((String)"org.eclipse.oomph.setup.core", (String)"org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil");
                Method createResourceSetMethod = setupCoreUtilClass.getMethod("createResourceSet", new Class[0]);
                Class imageDataClass = CommonPlugin.loadClass((String)"org.eclipse.swt", (String)"org.eclipse.swt.graphics.ImageData");
                imageDataConstructor = imageDataClass.getConstructor(InputStream.class);
                Class imageDescriptorClass = CommonPlugin.loadClass((String)"org.eclipse.jface", (String)"org.eclipse.jface.resource.ImageDescriptor");
                imageDescriptorCreateFromImageDataMethod = imageDescriptorClass.getMethod("createFromImageData", imageDataClass);
                ResourceSet resourceSet = (ResourceSet)createResourceSetMethod.invoke(null, new Object[0]);
                uriConverter = resourceSet.getURIConverter();
                options = resourceSet.getLoadOptions();
            }
            catch (Throwable throwable) {}
            URI_CONVERTER = uriConverter;
            OPTIONS = options;
            IMAGE_DATA_CONSTRUCTOR = imageDataConstructor;
            IMAGE_DESCRIPTOR_CREATE_FROM_IMAGE_DATA_METHOD = imageDescriptorCreateFromImageDataMethod;
        }

        public static final Object create(URI uri) {
            if (URI_CONVERTER == null) {
                return uri;
            }
            return new RemoteImage(uri);
        }

        public RemoteImage(URI uri) {
            super(Collections.singletonList(uri));
        }

        public boolean equals(Object that) {
            return that instanceof RemoteImage && ((RemoteImage)((Object)that)).images.equals(this.images);
        }

        public List<Object> getImages() {
            List images = super.getImages();
            URI uri = (URI)images.get(0);
            try {
                Object imageData = IMAGE_DATA_CONSTRUCTOR.newInstance(URI_CONVERTER.createInputStream(uri, OPTIONS));
                Object imageDescriptor = IMAGE_DESCRIPTOR_CREATE_FROM_IMAGE_DATA_METHOD.invoke(null, imageData);
                return Collections.singletonList(imageDescriptor);
            }
            catch (Throwable throwable) {
                return images;
            }
        }
    }
}

