/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class PreferencePageParameterValues
implements IParameterValues {
    private Map preferenceMap;

    public PreferencePageParameterValues() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            if (event.getExtensionDeltas("org.eclipse.ui", "preferencePages").length > 0) {
                this.preferenceMap = null;
            }
        });
    }

    private void collectParameterValues(Map values, IPreferenceNode[] preferenceNodes, String namePrefix) {
        IPreferenceNode[] iPreferenceNodeArray = preferenceNodes;
        int n = preferenceNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode preferenceNode = iPreferenceNodeArray[n2];
            if (!WorkbenchActivityHelper.filterItem(preferenceNode)) {
                Object name = namePrefix == null ? preferenceNode.getLabelText() : namePrefix + WorkbenchMessages.PreferencePageParameterValues_pageLabelSeparator + preferenceNode.getLabelText();
                String value = preferenceNode.getId();
                values.put(name, value);
                this.collectParameterValues(values, preferenceNode.getSubNodes(), (String)name);
            }
            ++n2;
        }
    }

    public Map getParameterValues() {
        if (this.preferenceMap == null) {
            this.preferenceMap = new TreeMap();
            PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
            this.collectParameterValues(this.preferenceMap, preferenceManager.getRootSubNodes(), null);
        }
        return this.preferenceMap;
    }
}

